<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;

class RedditService  extends BaseService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = ucwords(strtolower($product->title_replacement));
        $this->merchantProductService->buildSpecificInfo($product);
        $source = 'mga_source=reddit_ads';
        if (array_key_exists('mga_source',$input)){
            $source = 'mga_source=' . $input['mga_source'];
        }
        if (array_key_exists('utm_cam',$input)){
            $source .= '&utm_cam=' . $input['utm_cam'];
        }
        if (strpos($product->slug,'?') === false){
            $source = '?' . $source;
        }else{
            $source = '&' . $source;
        }
        $item = [
                $product->sku_code,
                $title,
                $title,
                (URL('/') . $prefixUrl . "/" . $product->slug . "-p" . $product->id.$source),
                $this->merchantProductService->buildImage($product),
                'in stock',
                $product->price . ' '. $currency,
                $country . $product->id,
                $this->merchantProductService->getProductType($product),

        ];
        $product = get_object_vars($product);
        $shoppingFeedConfig = $this->shoppingFeedConfig;
        $age = isset($shoppingFeedConfig['columns']['g:age_group']) ? call_user_func_array($shoppingFeedConfig['columns']['g:age_group'], [&$product]) : ' ';
        $color = isset($shoppingFeedConfig['columns']['g:color']) ? call_user_func_array($shoppingFeedConfig['columns']['g:color'], [&$product]) : ' ';
        $gender = isset($shoppingFeedConfig['columns']['g:gender']) ? call_user_func_array($shoppingFeedConfig['columns']['g:gender'], [&$product]) : '';
        $item[] = $age;
        $item[] = $color;
        $item[] = $gender;
        $this->items[$country . $product['id']] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $filePath = 'feeds/' . $locale . '/reddit';
        $input['localeFolder'] = $this->publicPath . $filePath;
        $items = $this->items;
        $existsProducts = ['custom_label_0' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[7]])) {
                $currRow = $items[$currRow[7]];
                unset($items[$currRow[7]]);
            }
            if (!isset($existsProducts[$currRow[7]])){
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[7]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
        if (!empty($input['fileName'])) {
            $retVal = [];
            $retVal['local_path'] = $input['localeFolder'] . "/" . $input['fileName'];
            $retVal['storage_path'] = $filePath . "/" . $input['fileName'];
            return $retVal;
        }
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'id',
            'title',
            'description',
            'link',
            'image_link',
            'availability',
            'price',
            'custom_label_0',
            'product_type',
            'age_group',
            'color',
            'gender'
        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            if (empty($product->sku_category_merchant_id)){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }
    public function buildFilterData($input)
    {
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = [
            'status' => 'ACTIVE',
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1
        ];
        if (array_key_exists('social_type',$input)){
            $filter['social_status'] = 1;
            $filter['social_type'] = $input['social_type'];
        }else{
            $filter['approve_advertising'] = 1;
        }
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
        }
        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('sold_from',$input)){
            $filter['sold_from'] = $input['sold_from'];
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(',',$input['ids']);;
        }
        if(array_key_exists('categoryIds',$input)){
            $filter['categoryIds'] = explode(',',$input['categoryIds']);;
        }
        $filter['columns'] = [
            // ORIGIN
            'product.id',
            'product.slug', 'product.brand_id', 'product.image_url',
            'product.description',
            'product.status', 'product.approve_advertising',
            'product.is_trademark',
            'product.gtin',
            'product.is_always_on_ads',
            'product.actor_id',
            'product.created_at',
            'product.sold',
            // SKU
            'product_info.name as sku_name',
            'product_info.variants as sku_specific_info',
            'product_info.brand as sku_brand',
            'product.sku as sku_code',
            'product_info.slug as sku_slug',
            'product_info.price',
            'product_info.inventory',
            'product_info.high_price',
            'product_info.category_merchant_id as sku_category_merchant_id',
            'product_info.product_sku_id',
            'product_info.product_sku_id as sku_id',
            'product_info.is_default',
            'product_n_category.category_id as category_id',
            'product.name as title_replacement',
        ];

        $query = $this->merchantProductService->buidFilter($filter);
        $products = $query->get();
        $input['prefixUrl'] = $prefixUrl;
        $input['country'] = $countryCode;
        $retVal = [];
        $retVal['products'] = $products;
        $retVal['input'] = $input;
        $retVal['locale'] = $locale;
        return $retVal;
    }
}