<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Controllers\AdsController;
use Module;
use Cache;

class SearchAdService extends BaseService
{
    private $adsController;
    protected $googleAdsApiToken;
    public function __construct(AdsController $adsController)
    {
        $this->adsController = $adsController;
        $this->googleAdsApiToken = \Config::get('ads::ads.google_ads_api_token');
    }
    public function getProducts($filter){
        $retVal = [];
        $ids = $this->getProductRecentlyOrder($filter);
        if (!empty($ids)){
            $filter['ids'] = $ids;
            $categoryIds = \Config::get('ads::ads.searchAd.categoryIds');
            if (!empty($categoryIds)){
                $filter['categoryIds'] = $categoryIds;
            }
            $retVal = $this->getProductForCreateAd($filter);

        }
        return $retVal;
    }
    private function getProductRecentlyOrder($filter){
        $query = DB::table('order_item')
            ->join('order', 'order.id', 'order_item.order_id')
            ->where('order.payment_status','PAID');
        if(array_key_exists('created_at_from', $filter)){
            $query->where('order.created_at','>=', $filter['created_at_from']);
        }
        if(array_key_exists('order_id_from', $filter)){
            $query->where('order.id','>=', $filter['order_id_from']);
        }
        if(array_key_exists('order_id_to', $filter)){
            $query->where('order.id','<=', $filter['order_id_to']);
        }
        $query->groupBy('order_item.product_id');
        $retVal = $query->pluck('order_item.product_id');
        return $retVal;
    }

    private function getProductForCreateAd($filter){
        $query = DB::table('product')
            ->join('product_n_category', 'product.id', 'product_n_category.product_id')
            ->join('category', 'category.id', 'product_n_category.category_id')
            ->join('tag_refer', 'tag_refer.refer_id', 'product.id')
            ->join('tag', 'tag_refer.tag_id', 'tag.id')
            ->where('product_n_category.is_parent',0)
            ->where('tag_refer.refer_type','PRODUCT');
        if(array_key_exists('ids', $filter)){
            $query->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('categoryIds', $filter)){
            $query->whereIn('category.id', $filter['categoryIds']);
        }
        $query->groupBy('product.id');
        return $query->get(['product.id','product.name','category.name as categoryName','product.slug','product.price', 'tag.title as tagName']);
    }



    public function isCreate($productId){
        $query =  DB::table('adgroup');
        $query->where('product_id',$productId);
        return $query->count() > 0;
    }

    public function saveAdgroup($input){
        $keywords = $input['keywords'];
        $product = $input['product'];
        $dataAdgroup = [
            'customerId' => $input['customerId'],
            'campaignId' => $input['campaignId'],
            'adgroup' =>[
                'name' => $keywords[0] . " [$product->id]",
                'cpc_bid' => 10000000000,
                'cpa_bid' => 250000000000,
                'status' => 2,
                'type' => 2
            ]
        ];
        $url = \Config::get('ads::ads.google_ads_api_url'). '/adgroup';

        $result = $this->triggerSyncRequest($url,'POST', $dataAdgroup, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
        $resourceName = isset($result['result'])?$result['result']:'';
        $explodeResource = explode('/',$resourceName);
        $id = DB::table('adgroup')->insertGetId(
            [
                'adgroup_id' => $explodeResource[count($explodeResource)-1],
                'campaign_id' => $dataAdgroup['campaignId'],
                'name' => $dataAdgroup['adgroup']['name'],
                'product_id' => $product->id,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'start_at' => date('Y-m-d H:i:s'),
                'cpc_bid' => $dataAdgroup['adgroup']['cpc_bid'],
                'cpa_bid' => $dataAdgroup['adgroup']['cpa_bid'],
                'resource_name' => $resourceName,

            ]
        );
        return [
            'adgroupId' => $id,
            'resourceName' => $resourceName
        ];
    }
    public function saveAd($input){
        $templates = $this->buildTemplateAd($input);
        $product = $input['product'];
        $url = \Config::get('ads::ads.google_ads_api_url',''). '/ad/create-responsive-search-ad';
        foreach ($templates as $item){
            $dataAd = [
                'customerId' => $input['customerId'],
                'headlines' => $item['headlines'],
                'descriptions' => $item['descriptions'],
                'paths' => substr(str_slug($product->categoryName),0,15) . '|' . substr(str_slug($product->tagName),0,15),
                'urls' => [(URL('/') . $input['prefixUrl'] . "/" . $product->slug . '-p' . $product->id)],
                'status' => 2,
                'resourceName' => $input['resourceName'],
            ];

            $result = $this->triggerSyncRequest($url,'POST', $dataAd, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
            $resourceName = isset($result['result'])?$result['result']:'';
            DB::table('ad')->insert(
                [
                    'headlines' => $dataAd['headlines'],
                    'descriptions' => $dataAd['descriptions'],
                    'paths' => $dataAd['paths'],
                    'final_url' => $dataAd['urls'][0],
                    'adgroup_id' => $input['adgroup_id'],
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'resource_name' => $resourceName,
                ]
            );


        }
    }
    public function saveKeywordAd($input){
        $keywords = $input['keywords'];
        $url = \Config::get('ads::ads.google_ads_api_url',''). '/keyword';
        foreach ($keywords as $keyword){
            $dataKeyword = [
                'customerId' => $input['customerId'],
                'keyword' => $keyword,
                'resourceName' => $input['resourceName']
            ];
            $result = $this->triggerSyncRequest($url,'POST', $dataKeyword, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
            $resourceName = isset($result['result'])?$result['result']:'';
            DB::table('keyword')->insert(
                [
                    'adgroup_id' => $input['adgroup_id'],
                    'text' => $keyword,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'resource_name' => $resourceName,
                ]
            );

        }

    }

    private function buildTemplateAd($input){
        $retVal = [];
        $product = $input['product'];
        $templates = \Config::get('ads::ads.searchAd.templates',[]);
        $currencyIcons = \Config::get('ads::ads.searchAd.currencyIcon',[]);
        $currency = env('CURRENCY_UNIT','USD');
        $icon = isset($currencyIcon[$currency])?$currencyIcons[$currency]:'$';
        foreach ($templates as $template){
            $data = [];
            $replace = [
                '[category]' => $product->categoryName,
                '[price]' => $icon . $product->price,
                '[keyword]' => $this->getKeyword($product)[0],
                '[title]' => $product->name
            ];
            $data['headlines'] = ucwords(strtolower(strtr($template['headlines'], $replace)));
            $data['descriptions'] = ucwords(strtolower(strtr($template['descriptions'],$replace)));
            $retVal[] = $data;
        }
        return $retVal;

    }
    public function getKeyword($item){
        $retVal = [];
        $text = ucwords(strtolower($item->tagName . ' ' . $item->categoryName));
        $retVal[] = $text;
//        $url = \Config::get('ads::ads.keyword_extractor_url').'/keyword';
//        $keywords = $this->triggerSyncRequest($url,'POST',['title' => [$text]],['Content-Type: application/json']);
//        return $keywords;
        return $retVal;
    }

}
