<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;

class TiktokService extends BaseService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];
    protected $increasePriceConfig = [];

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
        $config = DB::table('option')->where('key','price-change::ads-additional-price')->first(['value']);
        if (!empty($config) && !empty($config->value)){
            $this->increasePriceConfig = json_decode($config->value,true);
        }
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = ucwords(strtolower($product->title_replacement));
        $shippingFees = $this->merchantProductService->getShipping($product,$input);
//        $shippingFees = [];
        $this->merchantProductService->buildSpecificInfo($product);
        $shipping = [];
        foreach($shippingFees as $shippingItem){
            $shipping[] = $shippingItem['country'] . ':' . $shippingItem['price'] . ' ' . $currency;
            break;
        }
        $source = 'mga_source=tiktok_ads&campaign_name=__CAMPAIGN_NAME__&campaign_id=__CAMPAIGN_ID__&utm_source=__SOURCE__';
        if (array_key_exists('mga_source',$input)){
            $source = 'mga_source=' . $input['mga_source'];
        }
        if (array_key_exists('utm_cam',$input)){
            $source .= '&utm_cam=' . $input['utm_cam'];
        }
        if (strpos($product->slug,'?') === false){
            $source = '?' . $source;
        }else{
            $source = '&' . $source;
        }
        $item = [
                $product->sku_code,
                $title,
                $title,
                (URL('/') . $prefixUrl . "/" . $product->slug . "-p" . $product->id.$source),
//                $this->merchantProductService->buildImage($product),
                getImageCdn($product->image_url,630,630),
                'in stock',
                $product->price . ' ' . $currency,
                '',
                $country . $product->id,
                $this->merchantProductService->getProductType($product),
                $product->sku_category_merchant_id,
                $product->sku_brand,
                implode(',', $shipping),
                'new',
                $this->merchantProductService->getLabel0($product),
                $this->merchantProductService->getLabel1($product),
                $this->merchantProductService->getLabel2($product),
                $product->sold >0 ? 'ordered':'',
                ''

        ];
        if (isset($this->increasePriceConfig[$product->id]) && isset($this->increasePriceConfig[$product->id]['value'])){
            $item[6] = $this->increasePrice($product->price,$this->increasePriceConfig[$product->id]['value']) . ' ' . $currency;
        }
        $key = $country . $product->id;
//        $this->merchantProductService->buildProductInfo($product,$item);
        $this->items[$key] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $filePath = 'feeds/' . $locale . '/tiktok';
        $input['localeFolder'] = $this->publicPath . $filePath;
        $items = $this->items;
        $existsProducts = ['mpn' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[8]])) {
                $currRow = $items[$currRow[8]];
                unset($items[$currRow[8]]);
            }
            if (!isset($existsProducts[$currRow[8]])){
                $currRow[3] = $this->addPram($currRow[3]);
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[8]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
        if (!empty($input['fileName'])) {
            $retVal = [];
            $retVal['local_path'] = $input['localeFolder'] . "/" . $input['fileName'];
            $retVal['storage_path'] = $filePath . "/" . $input['fileName'];
            return $retVal;
        }
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'sku_id',
            'title',
            'description',
            'link',
            'image_link',
            'availability',
            'price',
            'gtin',
            'mpn',
            'product_type',
            'google_product_category',
            'brand',
            'shipping(country:price)',
            'condition',
            'custom_label_0',
            'custom_label_1',
            'custom_label_2',
            'custom_label_3',
            'custom_label_4',
//            'age_group',
//            'size',
//            'color',
//            'gender'
        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            if (empty($product->sku_category_merchant_id)){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }

    public function getProductBySellerId($input){
        $sellerId = isset($input['sellerId']) ? $input['sellerId'] :0;
        if (!empty($sellerId)){
            if (!array_key_exists('created_at_from',$input)){
                $input['created_at_from'] = date('Y-m-d 00:00:00',strtotime('-3 months'));
            }
            $retVal = DB::table('product_n_user')
                ->where('user_id',$sellerId)
                ->pluck('product_id')->toArray();
        }
        if (empty($retVal)){
            $retVal = [0];
        }
        return $retVal;
    }
    public function remove($input, $locale = 'us'){
        $removeProducts = $input['removeProducts'];
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/tiktok';
        $this->processFile($input,function($currRow,$stream) use (&$removeProducts){
            if (!isset($removeProducts[$currRow[8]])) {
                fputcsv($stream, $currRow);
                $removeProducts[$currRow[8]] = 1;
            }
        });
    }

    private function addPram($url){
        $url_parts = parse_url($url);
        if (!isset($url_parts['scheme'])){
            return $url;
        }

        // If URL doesn't have a query string.
        if (isset($url_parts['query'])) { // Avoid 'Undefined index: query'
            parse_str($url_parts['query'], $params);
        } else {
            $params = array();
        }
       //mga_source=tiktok_ads&campaign_name=__CAMPAIGN_NAME__&campaign_id=__CAMPAIGN_ID__&utm_source=__SOURCE__
        $params['mga_source'] = 'tiktok_ads';     // Overwrite if exists
        $params['campaign_name'] = '__CAMPAIGN_NAME__';
        $params['campaign_id'] = '__CAMPAIGN_ID__';
        $params['utm_source'] = '__SOURCE__';

// Note that this will url_encode all values
        $url_parts['query'] = http_build_query($params);

// If you have pecl_http
//        return http_build_url($url_parts);
        return $url_parts['scheme'] . '://' . $url_parts['host'] . $url_parts['path'] . '?' . $url_parts['query'];
    }

    private function increasePrice($price,$rate){
        $price = roundUp($price * $rate,2);
        return $price;
    }

    public function buildFilterData($input)
    {
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = [
            'status' => 'ACTIVE',
            'approve_advertising' => 1,
            'advertising_status' => 1,
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1
        ];
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
        }
        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('sold_from',$input)){
            $filter['sold_from'] = $input['sold_from'];
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(',',$input['ids']);;
        }
        if(array_key_exists('categoryIds',$input)){
            $filter['categoryIds'] = explode(',',$input['categoryIds']);;
        }
        $filter['columns'] = [
            // ORIGIN
            'product.id',
            'product.slug', 'product.brand_id', 'product.image_url',
            'product.description',
            'product.status', 'product.approve_advertising',
            'product.is_trademark',
            'product.gtin',
            'product.is_always_on_ads',
            'product.actor_id',
            'product.created_at',
            'product.sold',
            'product.barcode',
            // SKU
            'product_info.name as sku_name',
            'product_info.variants as sku_specific_info',
            'product_info.brand as sku_brand',
            'product.sku as sku_code',
            'product_info.slug as sku_slug',
            'product_info.price',
            'product_info.inventory',
            'product_info.high_price',
            'product_info.category_merchant_id as sku_category_merchant_id',
            'product_info.product_sku_id',
            'product_info.product_sku_id as sku_id',
            'product_info.is_default',
            'product_n_category.category_id as category_id',
            'product.name as title_replacement',
        ];

        $query = $this->merchantProductService->buidFilter($filter);
        $products = $query->get();
        $input['prefixUrl'] = $prefixUrl;
        $input['country'] = $countryCode;
        $retVal = [];
        $retVal['products'] = $products;
        $retVal['input'] = $input;
        $retVal['locale'] = $locale;
        return $retVal;
    }
}