<?php

namespace Modules\Ads\Controllers;

use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Controllers\Service\SnapchatService;


class SnapchatController extends Controller
{
    private $merchantProductService;
    private $snapchatProductService;
    public function __construct(MerchantProductService $merchantProductService, SnapchatService $snapchatProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->snapchatProductService = $snapchatProductService;
    }
    public function cronUpdateFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        if(array_key_exists('trend',$input)){
         return $this->buildProductByIds($input);
        }
        $buildFilterData = $this->snapchatProductService->buildFilterData($input);
        $products = $buildFilterData['products'];
        $input = $buildFilterData['input'];
        $locale = $buildFilterData['locale'];
        $count = $this->snapchatProductService->buildProducts($products, $input);
        $this->snapchatProductService->store($input, $locale);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    private function buildProductByIds($input){
        $retVal = [];
        if (array_key_exists('sellerId',$input)){
            $ids =  $this->snapchatProductService->getProductBySellerId($input);
        }else{
            $ids =  $this->snapchatProductService->getProductTrend($input);
        }
        $param = [
            'fileName' =>$input['fileName'],
            'ignore_updated_at' =>'1',
            'append' =>'1',
            'truncate' =>'1',
            'rename' =>'1',
        ];
        if (array_key_exists('mga_source',$input)){
            $param['mga_source'] = $input['mga_source'];
        }
        if (array_key_exists('utm_cam',$input)){
            $param['utm_cam'] = $input['utm_cam'];
        }
        $index = 0;
        foreach (array_chunk($ids,100) as $aPart) {
            if ($index == 1){
                unset($param['append']);
                unset($param['truncate']);
            }
            $ids = implode(',',$aPart);
            $url = route('ads::ads:snapchat::feed',$param);
            $url = $url.'&ids='.$ids;
            $retVal = $this->triggerSyncRequest($url,'GET');
            $index ++;
        }
        return response()->json(['status' => 'successful', 'data' => $retVal]);
    }

    public function cronRemoveProduct(Request $request){
        $start = microtime(true);
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d 00:00:00",strtotime('-1 day'));
                }
            }
        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d 00:00:00",strtotime('-1 day'));
            }
        }
        \Log::info("Snapchat: " . json_encode($input));
        $filter['columns'] = [
            // ORIGIN
            'product.id'
        ];
        $query = $this->snapchatProductService->buildDeleteQuery($filter);
        $chunkCount = 100000;
        $count = 0;
        $query->chunk($chunkCount, function($products) use($prefixUrl,$countryCode, $input, &$count, $start, $locale){
            \Log::info("Snapchat remove count: " . $count ." " . (microtime(true) - $start));
            $input['prefixUrl'] = $prefixUrl;
            $input['country'] = $countryCode;
            $data = $this->snapchatProductService->buildRemoveProducts($products, $input);
            $count += count($data);
            $input['removeProducts'] = $data;
            $this->snapchatProductService->remove($input, $locale);
        });
        $totalTime = microtime(true) - $start;
        \Log::info("Snapchat process remove time miliseconds: " .json_encode($input). $totalTime);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

}
