<?php

namespace Modules\Ads\Controllers;

use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\TwitterService;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;


class TwitterController extends Controller
{
    private $merchantProductService;
    private $twitterProductService;
    public function __construct(MerchantProductService $merchantProductService, TwitterService $twitterProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->twitterProductService = $twitterProductService;
    }
    public function cronUpdateFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $buildFilterData = $this->twitterProductService->buildFilterData($input);
        $products = $buildFilterData['products'];
        $input = $buildFilterData['input'];
        $locale = $buildFilterData['locale'];
        $count = $this->twitterProductService->buildProducts($products, $input);
        $this->twitterProductService->store($input, $locale);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }
}
