<?php

use Illuminate\Support\Facades\Redis;

if (!function_exists('getPrefixUrl')) {
    function getPrefixUrl()
    {
        return isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
    }
}

if (!function_exists('translate')) {
    function translate($key, $default = '')
    {
        $filePath = base_path() . "/resources/lang/" . getLocale() . ".json";
        $retval = $default ? $default : $key;
        if (file_exists($filePath)) {
            $str = file_get_contents($filePath);
            if ($str) {
                $dic = json_decode($str, true);
                if (isset($dic[$key])) {
                    $retval = $dic[$key];
                }
            }
        }
    
        return $retval;
    }
}

if (!function_exists('getLocale')) {
    function getLocale()
    {
        return env('APP_LANG', 'vi');
    }
}

if (!function_exists('adsHelperCodeGenerator')) {
    function adsHelperCodeGenerator($type = null, $length = 7)
    {
        if ($type == null)
            throw new InvalidArgumentException('missing argument type');
        $retVal = '';
        $type = strtoupper($type);
        $key = $type;
        if (!Redis::exists($key)) {
            Redis::set($key, 0);
        }
        $nextId = Redis::incr($key);
        for ($i = 0; $i < $length - 1 - strlen("" . $nextId); $i++) {
            $retVal .= "0";
        }
        $retVal .= $nextId;
        return $retVal;
    }
}

if (!function_exists('initSkuCode')) {
    function initSkuCode($productId)
    {
        $skuCode = null;
        $check = true;
    
        while ($check) {
            $sku = adsHelperCodeGenerator('product_sku', 7);
            $exists = adsHelperCheckExists(['sku' => $sku], 'ProductSku');
            if (!$exists) {
                $skuCode = '';
                $skuCode .= str_pad($productId, 4, '0', STR_PAD_LEFT);
                $skuCode .= $sku;
                $check = false;
            }
        }
    
        return $skuCode;
    }
}

if (!function_exists('adsHelperCheckExists')) {
    function adsHelperCheckExists($args = null, $model)
    {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func($model . '::query'));
        foreach ($args as $key => $value) {
            if (strpos($key, '!') !== false) {
                $key = str_replace('!', '', $key);
                $builder->where($key, '!=', $value);
            } else {
                $builder->where($key, '=', $value);
            }
        }
        return $builder->exists();
    }
}

