<?php

namespace Modules\Ads\Middlewares;

use Closure;

class AuthApiMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if ($request->has('seller_token')) {
            $exists = \DB::table('users')->where('seller_token', $request->get('seller_token'))
                ->where('status', 'ACTIVE')
                ->where('role', 'SELLER')
                ->exists();
            if ($exists) {
                return $next($request);
            }
        }
        return response()->json([
            'status' => 'fail',
            'message' => 'Permission Denied'
        ], 401);
    }
}
