<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbCampaignTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('campaign')) {
            Schema::create('campaign', function (Blueprint $table) {
                $table->increments('id');
                $table->string('campaign_id', 255)->default('');
                $table->string('campaign_name', 255)->nullable();
                $table->enum('campaign_type', ['EXPRESS', 'MULTI_CHANNEL', 'VIDEO', 'SHOPPING', 'DISPLAY', 'SEARCH', 'UNKNOWN'])->nullable();
                $table->string('account', 255)->nullable();
                $table->string('status', 255)->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('campaign_id', 'campaignId');
                $table->index('status', 'status');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_unicode_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('campaign');
    }
}
