<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbClickTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('click')) {
            Schema::create('click', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id')->nullable();
                $table->integer('product_sku_id')->nullable();
                $table->string('sku', 255)->nullable();
                $table->string('url', 500)->nullable();
                $table->string('source', 125)->nullable();
                $table->string('campaign_id', 32)->nullable();
                $table->enum('campaign_type', ['EXPRESS', 'MULTI_CHANNEL', 'VIDEO', 'SHOPPING', 'DISPLAY', 'SEARCH', 'UNKNOWN'])->nullable()->default('UNKNOWN');
                $table->integer('clicks')->nullable();
                $table->date('date')->nullable();
                $table->string('uniq_id', 64)->nullable();
                $table->unique('uniq_id', 'uniq');
                $table->index('date', 'date');
                $table->index('product_id', 'productId');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('click');
    }
}
