<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbProductAdvertisingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('product_advertising')) {
            Schema::create('product_advertising', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id')->nullable();
                $table->integer('product_sku_id')->nullable();
                $table->string('sku', 32)->nullable();
                $table->enum('ad_type', ['ggsp', 'text_ad', 'dsa', 'sgoa'])->nullable();
                $table->date('date')->nullable();
                $table->enum('ad_status', ['paused', 'enabled'])->nullable();
                $table->string('adgroup_name', 1000)->nullable();
                $table->string('account_key', 32)->nullable();
                $table->string('account_name', 255)->nullable();
                $table->string('adgroup_id', 64)->nullable();
                $table->string('campaign_id', 64)->nullable();
                $table->string('campaign_name', 1000)->nullable();
                $table->enum('campaign_status', ['paused', 'enabled'])->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('sku', 'sku');
                $table->index('date', 'date');
                $table->index('ad_type', 'ad_type');
                $table->index('ad_status', 'ad_status');
                $table->index('product_id', 'product_id');
                $table->index('product_sku_id', 'product_sku_id');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_advertising');
    }
}
