<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbProductToAdvertiseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('product_to_advertise')) {
            Schema::create('product_to_advertise', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id')->nullable();
                $table->integer('product_sku_id')->nullable();
                $table->string('sku', 20)->collation('utf8_unicode_ci')->default('');
                $table->string('title', 255)->nullable()->collation('utf8_unicode_ci');
                $table->string('link', 500)->nullable()->collation('utf8_unicode_ci');
                $table->integer('inventory')->nullable();
                $table->enum('status', ['running', 'pending'])->collation('utf8_unicode_ci')->default('pending');
                $table->text('data')->nullable()->collation('utf8_unicode_ci');
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('sku', 'sku');
                $table->index('product_id', 'product_id');
                $table->index('product_sku_id', 'product_sku_id');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_to_advertise');
    }
}
