<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateProductReportTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('product_report')) {
            Schema::create('product_report', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id')->nullable();
                $table->integer('product_sku_id')->nullable();
                $table->string('sku', 32)->nullable();
                $table->integer('click')->nullable();
                $table->integer('sale')->nullable();
                $table->enum('device', ['mobile', 'desktop', 'tablet', 'other'])->nullable();
                $table->date('date')->nullable();
                $table->string('uniq_id', 64)->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->unique('uniq_id', 'uniq_id');
                $table->index('product_id', 'product_id');
                $table->index('product_sku_id', 'product_sku_id');
                $table->index('sku', 'sku');
                $table->index('date', 'date');
                $table->index('device', 'device');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_report');
    }
}
