<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbSettingShoppingFeedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('sb_setting_shopping_feed')) {
            Schema::create('sb_setting_shopping_feed', function (Blueprint $table) {
                $table->increments('id');
                $table->string('name', 255)->nullable();
                $table->integer('category_id')->nullable();
                $table->tinyInteger('is_only_variant')->nullable()->default(0);
                $table->tinyInteger('is_variant_title')->nullable()->default(0);
                $table->integer('google_product_taxonomy_id')->nullable();
                $table->string('url', 2083)->nullable();
                $table->string('out_of_stock_url', 2083)->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->string('type', 255)->nullable();
                $table->tinyInteger('check_approve')->nullable();
                $table->tinyInteger('check_inventory')->nullable();
                $table->tinyInteger('check_paid')->nullable();
                $table->text('tags')->nullable();
                $table->string('spreadsheet_id', 100)->nullable();
                $table->string('spreadsheet_tab_name', 50)->nullable();
                $table->bigInteger('product_id_from')->nullable()->default(0);
                $table->bigInteger('product_id_to')->nullable()->default(0);

                $table->charset = 'utf8mb4';
                $table->collation = 'utf8mb4_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
//        Schema::dropIfExists('sb_setting_shopping_feed');
    }
}
