<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbMerchantProductTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('sb_merchant_product')) {
            Schema::create('sb_merchant_product', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id');
                $table->string('sku', 32)->default('');
                $table->dateTime('created_at');
                $table->dateTime('updated_at');
                $table->index('product_id', 'product_id');
                $table->index('updated_at', 'updated_at');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sb_merchant_product');
    }
}
