<?php

namespace Modules\Ads\Models;
use Illuminate\Database\Eloquent\Model;

class ApproveAdvertising extends Model
{
    protected $table = 'product_approve_advertising';

    protected $fillable = [
        'product_id',
        'code',
        'title',
        'description',
        'brand',
        'advertising_status',
        'created_at',
        'updated_at'
    ];

    protected $appends = ["logs", "logsProduct"];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function getLogsAttribute() {
        $logs = Log::where("target_type", "ADVERTISING")->where('target_id', $this->id)->orderby("created_at", "DESC")->get();
        return $logs;
    }

    public function getLogsProductAttribute() {
        $logs = Log::where("target_type", "PRODUCT")->where('target_id', $this->product_id)->orderby("created_at", "DESC")->get();
        return $logs;
    }

    protected static function boot()
    {
        parent::boot();        
        static::updating(function($model) {
            $user = isset($GLOBALS['globalUser']) ? $GLOBALS['globalUser'] : null;
            $email = !empty($user) ? $user->email : '';
            $oldAdvertising = ApproveAdvertising::where("id", $model->id)->first();
            $dataOld = [];
            $data = [];
            if ($model->title != $oldAdvertising->title) {
                $dataOld["title"] = $oldAdvertising->title;
                $data["title"] = $model->title;
            }
            if ($model->description != $oldAdvertising->description) {
                $dataOld["description"] = $oldAdvertising->description;
                $data["description"] = $model->description;
            }
            if ($model->advertising_status != $oldAdvertising->advertising_status) {
                if (!$user || $user->role == "STAFF") {
                    throw new \Exception('Permission Deny!', 403);
                }
                $dataOld["advertising_status"] = $oldAdvertising->advertising_status;
                $data["advertising_status"] = $model->advertising_status;
            }
            Log::create([
                'actor_email' => $email,
                'target_id' => $model->id,
                'target_type' => "ADVERTISING",
                'event_type' => Log::EVENT_TYPE_UPDATE_ADVERTISING,
                'data' => json_encode(["old_data" => $dataOld, "new_data" => $data])
            ]);
        });
    }
}
