<?php

namespace Modules\Ads\Models;

use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class Click extends Model
{
    use BaseTrait;
    public $timestamps = false;
    protected $table = 'click';
    protected $guarded = ['id'];
    protected $fillable = ['code', 'url', 'source', 'campaign_id', 'campaign_type', 'clicks', 'date', 'uniq_id'];
    static $operationFilter = [
        'eq' => [
            'source',
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'date_gte',
                'column' => 'date',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'date_lte',
                'column' => 'date',
            ]
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];

    public static function buildClickQuery($filter) {
        $query = self::buildQuery($filter);
        if (array_key_exists('join_order_item', $filter)) {
            $query->join('order_item', 'order_item.order_id', '=', 'order.id');
        }

        return $query;
    }
}
