<?php
namespace Modules\Ads\Models;

use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    protected $table = 'countries';
    static $cache = [];

    public static function getByCode($cCode, $columns = ['id']) {
        if (!array_key_exists($cCode, self::$cache)) {
            self::$cache[$cCode] = Country::where('iso', $cCode)->first($columns);
        }
        return self::$cache[$cCode];
    }
}
