<?php

namespace Modules\Ads\Models;

use Illuminate\Support\Facades\DB;
use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use BaseTrait;

    public $timestamps = false;
    protected $table = "order";

    const STATUS_OUT = 'OUT';

    static $operationFilter = [
        'eq' => [
            'source', 'type', 'from',
            'payment_type', 'payment_status',
            'warehouse_id', 'country_id'
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'create_time_gte',
                'column' => 'created_at',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'create_time_lte',
                'column' => 'created_at',
            ]
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];

    public static function buildOrderQuery($filter) {

        $query = self::buildQuery($filter);
        if (array_key_exists('join_order_item', $filter)) {
            $query->join('order_item', 'order_item.order_id', '=', 'order.id');
        }
        if (array_key_exists('join_order_meta_campaign', $filter)) {
            $query->join('order_meta as order_meta_campaign', function($join) {
                $join->on('order_meta_campaign.order_id', '=', 'order.id')
                    ->where('order_meta_campaign.key', '=', 'campaign_id')
                    ->whereNotNull('order_meta_campaign.key');
                    //->where('order_meta_campaign.key', '!=', 0);
            });
        }

        if (array_key_exists('join_order_meta_adwords', $filter)) {
            $query->join(DB::raw('sb_order_meta as order_meta_adwords'), function($join) {
                $join->on(DB::raw('order_meta_adwords.order_id'), '=', 'order.id')
                    ->where(DB::raw('order_meta_adwords.key'), '=', 'from')
                    ->where(DB::raw('order_meta_adwords.value'), '=', 'adwords');
            });
        }

        if (array_key_exists('join_order_meta_source', $filter)) {
            $query->join(DB::raw('sb_order_meta as order_meta_source'), function($join) use ($filter) {
                $join->on(DB::raw('order_meta_source.order_id'), '=', 'order.id')
                    ->where(DB::raw('order_meta_source.key'), '=', 'from')
                    ->where(DB::raw('order_meta_source.value'), '=', $filter['join_order_meta_source']);
            });
        }
        return $query;
    }

    public function items() {
        return $this->hasMany(OrderItem::class, 'order_id');
    }

    public function device() {
        return $this->hasMany(OrderMeta::class, 'order_id')->where('key', '=', 'device');
    }
}
