<?php

namespace Modules\Ads\Models;

use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class ProductAdwordsConversion extends Model
{
    use BaseTrait;
    public $timestamps = true;
    protected $table = "product_adwords_conversion";

    protected $fillable = [
        'product_id', 'product_sku_id', 'click', 'conversion',
        'campaign_id',  'campaign_type', 'type', 'date'
    ];

    static $operationFilter = [
        'eq' => [
            'product_id',
            'product_sku_id',
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'date_gte',
                'column' => 'date',
            ],
            [
                'filter' => 'conversion_from',
                'column' => 'conversion',
            ],[
                'filter' => 'adwords_click_from',
                'column' => 'adwords_click',
            ],
            [
                'filter' => 'organic_click_from',
                'column' => 'organic_click',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'date_lte',
                'column' => 'date',
            ]
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];

    public static function deleteAndCreate($data) {
        $exists = self::buildQuery([
            'product_id' => $data['product_id'],
            'product_sku_id' => $data['product_sku_id'],
            'date' => $data['date'],
            'campaign_id' => $data['campaign_id'],
        ])->exists();
        if ($exists) {
            self::buildQuery([
                'product_id' => $data['product_id'],
                'product_sku_id' => $data['product_sku_id'],
                'date' => $data['date'],
                'campaign_id' => $data['campaign_id'],
            ])->update($data);
        } else {
            ProductAdwordsConversion::create($data);

        }

    }

}
