<?php

namespace Modules\Ads\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Ads\Models\Traits\BaseTrait;

class ProductApproveAdvertising extends Model
{
    use BaseTrait;
    protected $table = 'product_approve_advertising';
    protected $guarded = ['id'];
    protected $fillable = [
        'product_id',
        'code',
        'title',
        'description',
        'brand',
        'advertising_status',
        'ctr',
        'created_at',
        'updated_at'
    ];

    protected $appends = ["productUrl"];

    public function getProductUrlAttribute()
    {
        $product = Product::where("id", $this->product_id)->first();
        return clroute($product->url);
    }

    public function getLogsAttribute() {
        $logs = Log::where("target_type", "ADVERTISING")->where('target_id', $this->id)->orderby("created_at", "DESC")->get();
        return $logs;
    }

    public function getLogsProductAttribute() {
        $logs = Log::where("target_type", "PRODUCT")->where('target_id', $this->product_id)->orderby("created_at", "DESC")->get();
        return $logs;
    }

    static $operationFilter = [
        'eq' => [
            "advertising_status"
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
            [
                'filter' => 'not_skus',
                'column' => 'code',
            ],
        ],
        //in
        'in' => [
            [
                'filter' => 'skus',
                'column' => 'code',
            ],
        ],
        'like' => []
    ];

    public static function buildProductAdvertisingQuery($filter) {
        $query = self::buildQuery($filter);
        $query->join("product", "product_approve_advertising.product_id", "=", "product.id");
        $query->whereNull("product.deleted_at");
        $query->whereIn("product.status", ["ACTIVE", "INACTIVE"]);
        self::decorQuery($query, $filter);
        return $query;
    }

    public static function decorQuery($query, $filter) {
        if (array_key_exists('search', $filter)) {
            $query->where(function($where) use ($filter) {
                $where->where('product_approve_advertising.title', 'like', '%' . $filter['search'] . '%')
                    ->orWhere('product_approve_advertising.code',  'like', '%' . $filter['search'] . '%')
                    ->orWhere('product_approve_advertising.product_id',  'like', '%' . $filter['search'] . '%');
            });
        }
    }
}
