<?php

namespace Modules\Ads\Models;

use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class ProductInfo extends Model
{
    use BaseTrait;

    public $timestamps = false;
    protected $table = "product_info";
    protected $guarded = ['id'];
    protected $fillable = ['product_id', 'product_sku_id','sku', 'name', 'slug', 'image_url', 'barcode', 'is_variant'];

    const STATUS_OUT = 'OUT';

    static $operationFilter = [
        'eq' => [
            'product_id', 'product_sku_id'

        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];
}
