<?php

namespace Modules\Ads\Models;

use Illuminate\Database\Eloquent\Model;

class ProductNCategory extends Model
{
    protected $table = 'product_n_category';
    protected $guarded = ['id'];
    public $timestamps = true;

    protected $fillable = ['product_id', 'category_id', 's_order'];


    public static function getCategory($productId) {
        $item = self::query()->where('product_id', $productId)
            ->where('is_parent', '0')
            ->first(['category_id']);
        return isset($item->category_id) ? $item->category_id : 0;
    }
}
