<?php

namespace Modules\Ads\Models;

use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class ProductReact extends Model
{
    use BaseTrait;
    public $timestamps = true;
    protected $table = "product_react";
    protected $fillable = [
        'product_id', 'product_sku_id', 'click',
        'conversion', 'adwords_click', 'organic_click',
        'bingads_click', 'other_click', 'date'
    ];
    static $operationFilter = [
        'eq' => [
            'product_id',
            'product_sku_id',
            'date',
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'date_gte',
                'column' => 'date',
            ],
            [
                'filter' => 'order_date_from',
                'column' => 'date',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'date_lte',
                'column' => 'date',
            ],
            [
                'filter' => 'order_date_to',
                'column' => 'date',
            ],
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
            [
                'filter' => 'product_ids',
                'column' => 'product_id',
            ],
            [
                'filter' => 'product_sku_ids',
                'column' => 'product_sku_id',
            ],
        ],
        'like' => []
    ];

    public static function deleteAndCreate($data) {
        $exists = self::buildQuery([
            'product_id' => $data['product_id'],
            'product_sku_id' => $data['product_sku_id'],
            'date' => $data['date'],
        ])->exists();
        if ($exists) {
            self::buildQuery([
                'product_id' => $data['product_id'],
                'product_sku_id' => $data['product_sku_id'],
                'date' => $data['date'],
            ])->update($data);
        } else {
            ProductReact::create($data);

        }

    }

    public static function buildProductReactQuery($filter) {
        $query = self::buildQuery($filter);
        if (array_key_exists('click_from', $filter) && $filter['click_from'] > 0) {
            $query->having('total_click', '>=', $filter['click_from']);
        }
        if (array_key_exists('adwords_click_from', $filter) && $filter['adwords_click_from'] > 0) {
            $query->having('adwords_click', '>=', $filter['adwords_click_from']);
        }
        if (array_key_exists('organic_click_from', $filter) && $filter['organic_click_from'] > 0) {
            $query->having('organic_click', '>=', $filter['organic_click_from']);
        }
        if (array_key_exists('bingads_click_from', $filter) && $filter['bingads_click_from'] > 0) {
            $query->having('bingads_click', '>=', $filter['bingads_click_from']);
        }

        self::decorQuery($query, $filter);
        if (array_key_exists('group', $filter)) {
            $query->groupBy($filter['group']);
        }
        return $query;
    }

    public static function decorQuery($query, $filter) {

    }
}

