<?php

namespace Modules\Ads\Models;

use Modules\Ads\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class ProductReactBySource extends Model
{
    use BaseTrait;
    public $timestamps = true;
    protected $table = "product_react_by_source";
    protected $fillable = [
        'product_id', 'product_sku_id', 'click',
        'conversion', 'date', 'source'
    ];
    static $operationFilter = [
        'eq' => [
            'product_id',
            'product_sku_id',
            'date',
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'date_gte',
                'column' => 'date',
            ],
            [
                'filter' => 'order_date_from',
                'column' => 'date',
            ],
            [
                'filter' => 'conversion_from',
                'column' => 'conversion',
            ],
            [
                'filter' => 'click_from',
                'column' => 'click',
            ],
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'date_lte',
                'column' => 'date',
            ],
            [
                'filter' => 'order_date_to',
                'column' => 'date',
            ],
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
            [
                'filter' => 'product_ids',
                'column' => 'product_id',
            ],
            [
                'filter' => 'product_sku_ids',
                'column' => 'product_sku_id',
            ],
        ],
        'like' => []
    ];

    public static function updateOrCreate($data) {
        $exists = ProductReactBySource::where([
            'product_id' => $data['product_id'],
            'product_sku_id' => $data['product_sku_id'],
            'date' => $data['date'],
            'source' => $data['source'],
        ])->exists();
        if ($exists) {
            ProductReactBySource::where([
                'product_id' => $data['product_id'],
                'product_sku_id' => $data['product_sku_id'],
                'date' => $data['date'],
                'source' => $data['source'],
            ])->update($data);
        } else {
            ProductReactBySource::create($data);

        }

    }
}

