<?php

namespace Modules\Ads\Models;

use Illuminate\Database\Eloquent\Model;

class ProductToAdvertising extends Model
{
    protected $table = 'product_to_advertise';
    protected $guarded = ['id'];

    protected $fillable = ['sku', 'title', 'link', 'inventory', 'status', 'data'];

    public function ads() {
        return $this->hasMany('Modules\Ads\Models\ProductToAdvertisingAd', 'pta_id');
    }

}
