<?php
namespace Modules\Ads\Models;

use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{

    protected $table = "warehouse";
    protected $fillable = [
        'name', 'printing_code', 'location', 'country_id', 'phone', 'address', 'province_id', 'district_id', 'is_default', 'is_active'
    ];

    public function warehouseConfigs() {
        return $this->hasMany(WarehouseConfig::class, 'warehouse_id');
    }

    public function categoryConfigs() {
        return $this->hasMany(WarehouseCategory::class, 'warehouse_id');
    }

    public function warehouseShippingConfigs() {
        return $this->hasMany(WarehouseConfig::class, 'warehouse_id', 'id')->where("config_type", "shipping");
    }

    public function warehouseCostConfigs() {
        return $this->hasMany(WarehouseConfig::class, 'warehouse_id', 'id')->where("config_type", "cost");
    }

}
