<?php

namespace App\Modules\Ads\Request\DataExport;

use App\Modules\Ads\Request\ValidateJsonResponse;
use Illuminate\Foundation\Http\FormRequest;

class ExportPlatformRequest extends FormRequest
{
    use ValidateJsonResponse;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'fileName' => ['required', 'string', 'regex:/^marketing_team_/'],
            'ids' => 'required|string',
            'social_platform' => 'required|string|in:pinterest,tiktok,snapchat,twitter,facebook,reddit',
        ];
    }

    public function messages()
    {
        return [
            'fileName.required' => 'Please pass fileName!',
            'fileName.string' => 'The fileName field must be a string.',
            'fileName.regex' => 'The file name must start with "marketing_team_". Examples: [marketing_team_domain_locale_fileName.csv, marketing_team_printerval.com_us_facebook.csv]',
            'ids.required' => 'Please pass ids',
            'ids.string' => 'The ids field must be a string.',

            'social_platform.required' => 'Please pass social_platform. Select the following values: pinterest,tiktok,snapchat,twitter,facebook,reddit',
            'social_platform.string' => 'social_platform must be a string',
            'social_platform.in' => 'social_platform only selected: pinterest,tiktok,snapchat,twitter,facebook,reddit',
        ];
    }

}
