<?php

namespace App\Modules\Ads\Request;


use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpFoundation\JsonResponse;

trait ValidateJsonResponse
{
    public function failedValidation(Validator $validator)
    {
        try {
            Log::warning('Validation failed', [
                'error_data' => $validator->errors(),
                'error_url' => $this->fullUrl(),
                'data' => $this->all(),
            ]);
        } catch (\Exception $exception) {
            Log::error($exception);
        }

        throw new HttpResponseException(
            response()->json([
                'message' => $validator->errors()->first(),
                'errorCode' => 1,
                'data' => $validator->errors()
            ], JsonResponse::HTTP_UNPROCESSABLE_ENTITY)
        );
    }

}
