system.controller("AdsShoppingFeedController", AdsShoppingFeedController);

function AdsShoppingFeedController($scope, $http, $rootScope) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope);
    $scope.items = [];
    $scope.keyword = '';
    $scope.filters = {};
    $scope.isFiltering = false;
    $scope.displayedFilters = {};
    $scope.mode = 'list';
    $scope.feed = {
        product_config: 'all',
        export_variant: 'all',
        title_variant: 'no',
        google_product_taxonomy: null,
        check_approve: true,
        check_inventory: false,
        check_paid: false,
        tags: []
    };
    $scope.categories = [{id:null}];
    $scope.googleProductTaxonomy = [];
    $scope.initialize = function () {
        fetchItem();
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 1000,
            "timeOut": 5000,
            "extendedTimeOut": 1000
        };
        buildCategories();
        fetchTags();
    };

    function fetchItem() {
        $scope.isFiltering = ($scope.getCacheFilter('feed_is_filtering') == 'true');
        var filters = $scope.getCacheFilter('feed_filter');
        if (filters == null) {
            $scope.fetchItems(
                $scope.buildUrl("/setting_shopping_feed?sorts=-created_at&page_size=20&filters=type=shopping_feed")
            );
        } else {
            $scope.filters = JSON.parse(filters);
            var displayedFilters = $scope.getCacheFilter('feed_filter_display');
            if (displayedFilters != null) {
                $scope.displayedFilters = JSON.parse(displayedFilters);
                if ($scope.displayedFilters.keyword) {
                    $scope.keyword = $scope.displayedFilters.keyword;
                }
            }
            if (typeof filters.name != 'undefined' && filters.name.value != 'undefined') {
                $scope.keyword = filters.name.value;
            }
            $scope.filterItems();
        }
    }

    function fetchTags() {
        // tag?page_size=-1
        $http({
            method: 'GET',
            url: base_api_url + '/tag?page_size=-1'
        }).then(function successCallback(response) {
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.tags = response.data.result;
            }
        });
    }

    function buildCategories() {
        $http({
            method: 'GET',
            url: base_api_url + '/categories'
        }).then(function successCallback(response) {
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.categories = response.data.result;
            }
        });
    }

    $scope.save = function() {
        loading();
        var data = buildData();
        var failMessages = validating(data);
        if (failMessages != '') {
            toastr.error(failMessages);
            loaded();
            return false;
        }
        var url = base_api_url + '/setting_shopping_feed'
        var method = 'POST';
        if ($scope.mode == 'update') {
            method = 'PUT';
            url += '/' + data.id;
        }
        $http({
            method: method,
            url: url,
            data: data
        }).then(function success(response) {
            if (response.data.status == 'successful' && response.data.result.id != 'undefined') {
                if ($scope.mode != 'update') {
                    $scope.execute(response.data.result);
                }
                $scope.mode = 'list';
                fetchItem();
                toastr.success('Lưu feed thành công.');
            } else {
                toastr.error('Lưu feed không thành công. ' + response.data.message);
            }
            loaded();
        });
    };

    $scope.create = function() {
        $scope.feed = {
            product_config: 'all',
            export_variant: 'all',
            title_variant: 'no',
            google_product_taxonomy: null,
            check_approve: true,
            check_inventory: false,
            check_paid:false
        };
    }

    // Gọi lệch tạo url feed
    $scope.execute = function (data) {
        var locale = '';
        if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
            locale = '/' + localePrefix;
        }
        $http({
            method: 'PUT',
            url: base_api_url + '/setting_shopping_feed' + '/' + data.id,
            data: {
                'url': window.location.origin + locale + '/shopping-feed/' + data.id + '/' + $scope.slugify(data.name) + '-ads-on.xml',
                'out_of_stock_url': window.location.origin + locale + '/shopping-feed/' + data.id + '/' + $scope.slugify(data.name) + '-ads-off.xml'
            }
        }).then(function success(response) {
            fetchItem();
        });
    };

    $scope.edit = function (item) {
        $scope.feed = angular.copy(item);
        $scope.feed.product_config = 'all';
        
        if (item.category_id) {
            $scope.feed.category = $scope.getByField($scope.categories, 'id', item.category_id);
            $scope.feed.product_config = 'category';
        }
        if (item.google_product_taxonomy_id) {
            $scope.feed.google_product_taxonomy = $scope.getByField($scope.googleProductTaxonomy, 'id', item.google_product_taxonomy_id);
        }
        $scope.feed.export_variant = 'all';
        if (parseInt(item.is_only_variant)) {
            $scope.feed.export_variant = 'only';
        }
        $scope.feed.title_variant = 'no';
        if (parseInt(item.is_variant_title)) {
            $scope.feed.title_variant = 'yes';
        }
        $scope.feed.check_approve = false;
        if (parseInt(item.check_approve)) {
            $scope.feed.check_approve = true;
        }
        $scope.feed.check_inventory = false;
        if (parseInt(item.check_inventory)) {
            $scope.feed.check_inventory = true;
        }
        $scope.feed.check_paid = false;
        if (parseInt(item.check_paid)) {
            $scope.feed.check_paid = true;
        }
        if ($scope.feed.tags) {
            let tagIds = JSON.parse($scope.feed.tags);
            let selectedTags = [];
            tagIds.forEach(id => {
                selectedTags.push($scope.getByField($scope.tags, 'id', id));
            });

            $scope.feed.tags = selectedTags;
        }

        $scope.mode = 'update';
    }

    function loading() {
        $scope.loaddingButton('#btn-save-1');
        $('#btn-cancel').attr("disabled", true);
    }

    function loaded() {
        $scope.determinateValue = 100;
        $scope.stopLoaddingButton('#btn-save-1');
        $('#btn-cancel').attr("disabled", false);
    }

    function validating(data) {
        var retVal = '';
        if (typeof data.name == 'undefined') {
            retVal += '<p>Bạn phải nhập tên cho feed.</p>';
        }
        if ($scope.feed.product_config == 'category' && (data.category_id == null || data.category_id == '')) {
            retVal += '<p>Bạn phải chọn danh mục sản phẩm cho feed.</p>';
        }
        return retVal;
    }

    function buildData() {
        var retVal = {
            type: 'shopping_feed',
            is_only_variant: 0,
            is_variant_title: 0,
            category_id: null,
            google_product_taxonomy_id: null,
            check_approve: 0,
            check_inventory: 0,
            check_paid: 0
        };
        if (typeof $scope.feed.id != 'undefined' && $scope.feed.id != '') {
            retVal.id = $scope.feed.id;
        }
        if (typeof $scope.feed.name != 'undefined' && $scope.feed.name != '') {
            retVal.name = $scope.feed.name;
        }
        if ($scope.feed.product_config == 'category' && typeof $scope.feed.category != 'undefined' && typeof $scope.feed.category.id != 'undefined') {
            retVal.category_id = $scope.feed.category.id;
        }
        if ($scope.feed.export_variant == 'only') {
            retVal.is_only_variant = 1;
        }
        if ($scope.feed.title_variant == 'yes') {
            retVal.is_variant_title = 1;
        }
        if ($scope.feed.spreadsheet_tab_name) {
            retVal.spreadsheet_tab_name = $scope.feed.spreadsheet_tab_name;
        }
        if ($scope.feed.spreadsheet_id) {
            retVal.spreadsheet_id = $scope.feed.spreadsheet_id;
        }
        if ($scope.feed.check_approve) {
            retVal.check_approve = 1;
        }
        if ($scope.feed.check_inventory) {
            retVal.check_inventory = 1;
        }
        if ($scope.feed.check_paid) {
            retVal.check_paid = 1;
        }
        if ($scope.feed.tags) {
            retVal.tags = [];
            $scope.feed.tags.forEach(tag => {
                retVal.tags.push(tag.id);
            });
            retVal.tags = JSON.stringify(retVal.tags);
        }
        /* if (typeof $scope.feed.google_product_taxonomy != 'undefined' &&  $scope.feed.google_product_taxonomy != null && typeof $scope.feed.google_product_taxonomy.id != 'undefined') {
            retVal.google_product_taxonomy_id = $scope.feed.google_product_taxonomy.id;
        } */
        if ($scope.feed.product_id_from) {
            retVal.product_id_from = $scope.feed.product_id_from;
        }
        if ($scope.feed.product_id_to) {
            retVal.product_id_to = $scope.feed.product_id_to;
        }
        return retVal;
    }

    $scope.fetchItems = function (url) {
        $http.get(url).then(function (response) {
            $scope.items = response.data.result;
            $scope.meta = response.data.meta;
        });
    };

    $scope.searchFilter = function() {
        if ($scope.keyword.length > 0) {
            $scope.isFiltering = true;
            $scope.filters.name = {
                operator: "~",
                value: $scope.keyword
            };
            $scope.displayedFilters.keyword = $scope.keyword;
        } else {
            if (typeof $scope.filters.name != 'undefined') {
                delete $scope.filters.name;
            }
            if (typeof $scope.displayedFilters.keyword != 'undefined') {
                delete $scope.displayedFilters.keyword;
            }
            if (Object.keys($scope.filters).length == 0) {
                $scope.isFiltering = false;
            }
        }
        $scope.filterItems();
    }

    $scope.buildFilterItemUrl = function () {
        var url = $scope.buildFilterUrl("/setting_shopping_feed?filters=type=shopping_feed");
        url = $scope.buildSortUrl(url);
        url = $scope.buildPaginationUrl(url);
        url = $scope.buildUrl(url);
        return url;
    };

    $scope.filterItems = function () {
        $scope.cacheFilter('feed_is_filtering', $scope.isFiltering);
        $scope.cacheFilter('feed_filter', JSON.stringify($scope.filters));
        $scope.cacheFilter('feed_filter_display', JSON.stringify($scope.displayedFilters));
        $scope.filters.type = 'shopping_feed';
        var url = $scope.buildFilterItemUrl();
        $scope.fetchItems(url);
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.filterItems();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.filterItems();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.filterItems();
        }
    };

    $scope.removeAllFilters = function () {
        $scope.filters = {};
        $scope.displayedFilters = {};
        $scope.selectedFilter = "";
        $scope.isFiltering = false;
        $scope.keyword = "";

        $scope.filterItems();
    };

    $scope.deleteItem = function(idx, item) {
        if (typeof item.id != 'undefined' && item.id > 0) {
            var param = {
                title: 'Xóa feed',
                text: 'xóa feed này',
                arg: {id: item.id, idx: idx}
            };
            $scope.callConfirmModal(param, function(arg) {
                $http({
                    method: 'delete',
                    url: base_api_url + '/setting_shopping_feed/' + arg.id
                }).then(function success(response) {
                    if (response.data.status == 'successful') {
                        $scope.items.splice(arg.idx, 1);
                        toastr.success('Xóa bộ lọc thành công');
                    } else {
                        toastr.error('Xóa sản bộ lọc thành công');
                    }
                });
            });
        }
    }

    $scope.getEditUrl = function (item) {
        return `/admin/filters/${item.id}`;
    }

    $scope.initialize();
}
