system.controller(
    "ApproveByLinkController",
    ApproveByLinkController
);

function ApproveByLinkController($scope, $http, Upload) {
    $scope.productLinks = ``;
    $scope.loading = false;
    $scope.types = [
        {
            key: 'approve',
            value: 'Duyệt qc'
        },
        {
            key: 'disapprove',
            value: 'Bỏ duyệt qc'
        },
    ];
    $scope.type = undefined;

    $scope.productIds = '';

    $scope.$watch('productLinks', (newValue) => {
        $scope.productIds  = newValue.toLowerCase().replace(/(.*-p|^p)(\d+).*/gmi, '$2').trim();
        $scope.productIds  = $scope.productIds.replace(/\n+/g, ',').split(',').filter(value => value.trim()).join(',');
        console.log($scope.productIds );
    });


    $scope.buildProductUrl = (product) => {
        return window.location.origin + ((typeof localPrefix == 'undefined' || localPrefix == 'us' ) ? '/' : `/${localPrefix}`) + product.slug + '-p' + product.id;
    }

    $scope.save = () => {
        if (!$scope.productIds) {
            toastr.error('Vui lòng nhập link sản phẩm');
            return;
        }
        if (!$scope.type) {
            toastr.error('Vui lòng chọn hành động');
            return;
        }
        $scope.loading = true;
        let url  = '/product-advertise/cron/bulk-approve';
        if ($scope.type == 'disapprove') {
            url = '/product-advertise/cron/bulk-disapprove';
        }
        $http({
            url: url,
            method: 'POST',
            data: {
                product_ids: $scope.productIds,
                is_approved: 0,
                service_token: 'megaads@123'
            }
        }).then(function (response) {
            $scope.loading = false;
            if (response.data.status == 'successful') {
                toastr.success('Thành công');
            } else {
                toastr.error('Đã có lỗi xảy ra', response.data.message);
            }
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra');
            $scope.loading = false;
        })
    };
}
