system.controller("ApproveProductController", ApproveProductController);
system.requires.push('chosen-search');

function ApproveProductController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);

    $scope.filters = {};

    $scope.isSelectedAll = false;
    $scope.selectedProductLength = 0;
    $scope.loading = false;
    $scope.staffs = staffs;
    $scope.types = [
        {
            type: 'seller',
            name: 'Sp seller'
        },
        {
            type: 'seller_paid',
            name: 'Sp seller trả phí'
        }
    ];

    $scope.interactFilters = [
        {
            type: 'has_view',
            name: 'Có view, sold',
        },
        {
            type: 'not_has_view',
            name: 'Không có view, sold',
        }
    ]

    $scope.initialize = () => {
        $scope.reset();
        $scope.find();
    }

    $scope.reset = () => {
        $scope.filters = {};
        var now = new Date();
        now.setDate(now.getDate() - 7);

        $scope.filters.dateFrom = $scope.formatDate(now);
        $scope.filters.dateTo = $scope.formatDate(new Date());

        $scope.meta.page_id = 0;
        $scope.find(true);
    }

    $scope.padZero = function (num) {
        return num > 9 ? num : `0${num}`;
    }

    $scope.formatDate = function (date) {
        return  $scope.padZero(date.getDate()) + "/" + $scope.padZero(date.getMonth()+1) + "/" + date.getFullYear();
    }

    $scope.buildFilterUrl = (url) => {
        let filters = [];
        if ($scope.filters.dateFrom) {
            filters.push("date_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateFrom) + " 00:00:00");
        }

        if ($scope.filters.dateTo) {
            filters.push("date_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateTo) + " 23:59:59");
        }

        let keys = ['actor_id', 'user_id', 'type', 'interact'];
        for (let key of keys) {
            if ($scope.filters[key]) {
                filters.push(`${key}=${$scope.filters[key]}`);
            }
        }

        return url + (url.indexOf('?') > 0 ? '&' : '?') + filters.join('&');
    }

    $scope.find = (refresh = false) => {
        $scope.resetSelectedProducts();

        if (refresh) {
            $scope.meta.page_id = 0;
        }

        $scope.products = [];
        $scope.loading = true;

        $http.get($scope.buildUrl($scope.buildFilterUrl(`/ads/approve-product/find?page_id=${$scope.meta.page_id}`)))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.products = res.data.result;
                    for (let key in $scope.products) {
                        $scope.products[key].url = $scope.getProductUrl($scope.products[key]);
                    }
                    $scope.meta = res.data.meta;
                    if (res.data.result.length < $scope.meta.page_size) {
                        $scope.meta.page_count = $scope.meta.page_id + 1;
                        $scope.meta.has_next = false;
                    } else {
                        $scope.meta.page_count = $scope.meta.page_id + 5;
                    }
                    $scope.meta.hide_page_count = 1;
                }
                $scope.loading = false;
            }, err => {
                console.log(err);
                $scope.loading = false;
            })
    }

    $scope.getProductUrl = (product) => {
        return `${localePrefix && localePrefix != defaultLocale ? `/${localePrefix}/` : '/'}${product.slug}-p${product.id}`;
    }

    $scope.addSelectedProducts = function (index) {
        $scope.products[index].selected = !$scope.products[index].selected;
        if ($scope.products[index].selected) {
            $scope.selectedProductLength++
        } else {
            $scope.selectedProductLength--;
        }
        $scope.isSelectedAll = $scope.checkSelectedAll()
    };

    $scope.resetOrCheckAll = function () {
        for (let index in $scope.products) {
            $scope.products[index].selected = $scope.isSelectedAll;
        }
        $scope.selectedProductLength = $scope.isSelectedAll ? $scope.products.length : 0;
    }

    $scope.resetSelectedProducts = () => {
        $scope.isSelectedAll = 0;
        $scope.selectedProductLength = 0;
    }

    $scope.checkSelectedAll = function () {
        return !$scope.products.find(item => !item.selected);
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.approveAds = (item = null) => {
        $scope.callConfirmModal({
            title: 'Duyệt ads',
            text: "duyệt ads"
        }, function() {
            let productIds = [];
            if (item) {
                productIds.push(item.id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.id);
            }

            $http.post($scope.buildUrl("/ads/approve-product/approve"), {
                product_ids: productIds.join(','),
            })
            .then((res) => {
                if (res.data.status === 'successful') {
                    $scope.isLoading = false;
                    toastr.success("Duyệt thành công");
                }
            })
            .catch((e) => {
                $scope.isLoading = false;
                toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
            });
        });
    }

    $scope.disapproveAds = (item = null) => {
        $scope.callConfirmModal({
            title: 'Bỏ duyệt ads',
            text: "bỏ duyệt ads"
        }, function() {
            let productIds = [];
            let trademarkIds = [];
            if (item) {
                productIds.push(item.id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.id);
            }

            $http.post($scope.buildUrl("/ads/approve-product/disapprove"), {
                    product_ids: productIds.join(','),
                })
                .then((res) => {
                    if (res.data.status === 'successful') {
                        $scope.isLoading = false;
                        toastr.success("Bỏ duyệt thành công");
                    }
                })
                .catch((e) => {
                    $scope.isLoading = false;
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }

    $scope.initialize();
}