system.controller("BulkApproveProductController", BulkApproveProductController);

function BulkApproveProductController($scope, $http, $rootScope, $timeout) {

    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope);

    $scope.staffs = window.staffs;
    $scope.filters = {
        from: moment().subtract(3, 'days').format('DD/MM/YYYY'),
        to: moment().format('DD/MM/YYYY'),
        staff: null
    }
    $scope.products = [];
    $scope.categoryReport = [];
    $scope.checkboxCategory = {};
    $scope.checkboxProducts = {};

    $scope.states = {
        checkCount: 0,
        isLoading: true,
        isPushing: false,
        pushMessage: '',
        pushCount: 0
    }

    const checkAllProductEl = document.getElementById('selectAllProduct');
   
    $scope.checkIsChanged = function()
    {
        let checkCount = 0;
        
        for (const key in $scope.checkboxCategory) {
            if (Object.hasOwnProperty.call($scope.checkboxCategory, key)) {
                const element = $scope.checkboxCategory[key];
                if (element === true) {
                    checkCount += $scope.categoryReport[key].count;
                }
            }
        }

        if (checkCount > 0) {

            if (checkCount === $scope.products.length) {
                checkAllProductEl.indeterminate = false;
                checkAllProductEl.checked = true;
            } else {
                checkAllProductEl.indeterminate = true;
            }
            
        } else if (checkCount === 0) {
            checkAllProductEl.indeterminate = false;
        }

        $scope.states.checkCount = checkCount;
    }

    $scope.checkProduct = function(report, id)
    {
        $scope.checkboxCategory[id] = !$scope.checkboxCategory[id];

        for (const key in $scope.products) {
            if (Object.hasOwnProperty.call($scope.products, key)) {
                const product = $scope.products[key];
                if (product.category_id == id) {

                    if (typeof $scope.checkboxProducts[product.id] !== 'undefined') {
                        $scope.checkboxProducts[product.id] = true;
                    }

                    if ($scope.checkboxCategory[id])
                        $scope.checkboxProducts[product.id] = true;
                    else 
                        $scope.checkboxProducts[product.id] = false;
                }
            }
        }

        $scope.checkIsChanged();

        safeApply();
    }

    $scope.getProducts = getProducts;

    $scope.pushProducts = async function() 
    {
        if (!window.confirm("Xác nhận đẩy " + $scope.states.checkCount + " sản phẩm quảng cáo!")) {
            reutrn -1;
        }

        $scope.states.isPushing = true;

        const productIds = [];
        for (const key in $scope.checkboxProducts) {
            if (Object.hasOwnProperty.call($scope.checkboxProducts, key)) {
                const element = $scope.checkboxProducts[key];
                if (element === true) {
                    productIds.push(key);
                }
            }
        }

        $scope.states.lengthProductPushing = productIds.length;

        // log push data
        await $http.post('/product-advertise/bulk-approve/log-push', {
            userId: window.userId,
            filters: $scope.filters,
            productIds: productIds
        });

        // limit 100 product ids
        const chunkSize = 100;
        const pushPromises = [];

        for (let i = 0; i < productIds.length; i += chunkSize) 
        {
            const chunk = productIds.slice(i, i + chunkSize);
            const stringIds = chunk.join(',');

            const promise = pushP(stringIds);

            pushPromises.push(promise);

            promise.then(() => {
                $scope.states.pushCount += chunk.length;
                safeApply();
            });

        }

        Promise.all(pushPromises).then(()=>{
            setTimeout(() => 
            {
                $scope.states.isPushing = false;
                $scope.states.pushCount = 0;

                getProducts();
                safeApply();

            }, 500);
        })
    }

    function pushP(stringIds)
    {
        const url  = '/product-advertise/cron/bulk-approve';
        return $http({
            url: url,
            method: 'POST',
            data: {
                product_ids: stringIds,
                service_token: 'megaads@123',
                is_approved: 0
            }
        });
    }
        
    function checkAll()
    {
        if (!checkAllProductEl.checked) {
            
            $scope.checkboxCategory = {};
            $scope.checkboxProducts = {};
            $scope.states.checkCount = 0;

        } else {

            for (const key in $scope.categoryReport) {
                if (Object.hasOwnProperty.call($scope.categoryReport, key)) {
                    $scope.checkboxCategory[key] = true;
                }
            }

            for (let i = 0; i < $scope.products.length; i++) {
                const prod = $scope.products[i];
                $scope.checkboxProducts[prod.id] = true;
            }

            $scope.states.checkCount = $scope.products.length;
        }

        $scope.checkIsChanged();

        safeApply();
    }

    function reset() 
    {
        checkAllProductEl.indeterminate = false;
        checkAllProductEl.checked = false;

        $scope.products = [];
        $scope.categoryReport = [];
        $scope.checkboxCategory = {};
        $scope.checkboxProducts = {};

        $scope.states = {
            checkCount: 0,
            isLoading: true,
            isPushing: false,
            pushMessage: '',
            pushCount: 0
        }
    }

    function getProducts()
    {
        reset();

        $scope.states.isLoading = true;
        $scope.products = [];
        $scope.categoryReport = [];

        const filters = {
            from: moment($scope.filters.from, "DD/MM/YYYY").format('YYYY-MM-DD') + ' 00:00:00',
            to: moment($scope.filters.to, "DD/MM/YYYY").format('YYYY-MM-DD') + ' 23:23:59',
            staffId: $scope.filters.staff
        }

        const params = new URLSearchParams(filters).toString();

        $http.get('/product-advertise/get-product?' + params).then((response) => 
        {
            if (response.data.status == 'successful') {
                $scope.products = response.data.result.products;
                $scope.categoryReport = response.data.result.report;
            }

            $scope.states.isLoading = false;
        });
    }

    function init()
    {
        getProducts();
        
        // event
        document.addEventListener('error', function (event) {
            var elm = event.target;
            if (elm.tagName == 'IMG') {
                elm.src = "https://placehold.co/600x400?text=Product+Image";
            }
        }, true );

        checkAllProductEl.addEventListener('change', checkAll);
    }

    function safeApply() {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }

    init();

}