system.controller("MerchantCategoryController", MerchantCategoryController);

function MerchantCategoryController($scope, $http, $rootScope) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope);
    var self = this;
    $scope.items = [];
    $scope.keyword = '';
    $scope.filters = {};
    $scope.isFiltering = false;
    $scope.displayedFilters = {};
    $scope.preUpdateItem = [];
    $scope.mode = 'list';
    $scope.filter = {};
    $scope.initialize = function () {
        $scope.reset();
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 1000,
            "timeOut": 5000,
            "extendedTimeOut": 1000
        };
    };
    $scope.statuses = [
        {value:'',name:'Tất cả'},
        {value:'!=',name:'Đã cấu hình'},
        {value:'=',name:'Chưa cấu hình'}
    ];
    $scope.filter.status = $scope.statuses[2];

    $scope.save = function(item) {
        loading();
        delete item.edit;
        var url = base_api_url + '/category_google_merchant/' + item.id
        var method = 'PATCH';
        $http({
            method: method,
            url: url,
            data: item
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                for (var k in $scope.items) {
                    if ($scope.items[k].id === response.data.result.id) {
                        $scope.items[k] = response.data.result;
                        break;
                    }
                }
                toastr.success('Cập nhật thành công.');
            } else {
                self.cloneObject($scope.preUpdateItem[item.id], item);
                toastr.error('Cập nhật thất bại. ' + response.data.message);
            }
            loaded();
        });
    };


    function loading() {
        $scope.loaddingButton('#btn-save-1');
        $('#btn-cancel').attr("disabled", true);
    }

    function loaded() {
        $scope.determinateValue = 100;
        $scope.stopLoaddingButton('#btn-save-1');
        $('#btn-cancel').attr("disabled", false);
    }


    $scope.fetchItems = function (url) {
        $http.get(url).then(function (response) {
            $scope.items = response.data.result;
            $scope.meta = response.data.meta;
        });
    };

    $scope.searchFilter = function() {
        if ($scope.filter.status.value) {
            $scope.filters.category_merchant_id = {
                operator: $scope.filter.status.value,
                value: 'null'
            };
        }else{
            if (typeof $scope.filters.category_merchant_id != 'undefined') {
                delete $scope.filters.category_merchant_id;
            }
        }
        if ($scope.filter.keyword) {
            $scope.isFiltering = true;
            $scope.filters.name = {
                operator: "~",
                value: $scope.filter.keyword
            };
            $scope.displayedFilters.keyword = $scope.filter.keyword;
        }else {
            if (typeof $scope.filters.name != 'undefined') {
                delete $scope.filters.name;
            }
            if (typeof $scope.displayedFilters.keyword != 'undefined') {
                delete $scope.displayedFilters.keyword;
            }
            if (Object.keys($scope.filters).length == 0) {
                $scope.isFiltering = false;
            }
        }
        $scope.filterItems();
    }

    $scope.buildFilterItemUrl = function () {
        var url = $scope.buildFilterUrl("/category_google_merchant?sorts=-created_at");
        url = $scope.buildSortUrl(url);
        url = $scope.buildPaginationUrl(url,100);
        url = $scope.buildUrl(url);
        return url;
    };

    $scope.filterItems = function () {
        var url = $scope.buildFilterItemUrl();
        $scope.fetchItems(url);
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.filterItems();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.filterItems();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.filterItems();
        }
    };

    $scope.removeAllFilters = function () {
        $scope.filters = {};
        $scope.displayedFilters = {};
        $scope.selectedFilter = "";
        $scope.isFiltering = false;
        $scope.keyword = "";

        $scope.filterItems();
    };
    $scope.showUpdate = function (item) {
        $scope.preUpdateItem[item.id] = {};
        self.cloneObject(item, $scope.preUpdateItem[item.id]);
        item.edit = true;
    };

    $scope.cancelUpdate = function (item) {
        item.edit = false;
        self.cloneObject($scope.preUpdateItem[item.id], item);
    };
    this.cloneObject = function (source, destination) {
        for (var key in source) {
            destination[key] = source[key];
        }
    };
    $scope.reset = function() {
        $scope.filter = {};
        $scope.filter.status = $scope.statuses[2];
        $scope.searchFilter();
    }
    $scope.initialize();
}
