system.controller("PendingProductController", PendingProductController);

function PendingProductController($scope, $http, $rootScope, $timeout) {

    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope);

    $scope.staffs = window.staffs;
    $scope.filters = {
        from: moment().subtract(3, 'days').format('DD/MM/YYYY'),
        to: moment().format('DD/MM/YYYY'),
        staff: null
    }
    $scope.products = [];
    $scope.categoryReport = [];
    $scope.checkboxCategory = {};
    $scope.checkboxProducts = {};

    $scope.states = {
        checkCount: 0,
        isLoading: true,
        isPushing: false,
        pushMessage: '',
        pushCount: 0
    }

    $scope.productPagination = {
        number_page: 1,
        current_page: 1,
        page_size: 50
    };

    $scope.staffProductCount = [];
    $scope.reasons = {
        'policy_violation': 'Policy Violation',
        'condition_mismatch_detected': 'condition_mismatch_detected',
        'attribute_violated_discovery_ads_policy': 'attribute_violated_discovery_ads_policy',
        'image_link_internal_error': 'image_link_internal_error',
        'attribute_pending_review': 'attribute_pending_review',
        'image_link_pending_crawl': 'image_link_pending_crawl',
        'image_link_internal_error': 'image_link_internal_error'
    }

    const checkAllProductEl = document.getElementById('selectAllProduct');
   
    $scope.checkIsChanged = function()
    {
        let checkCount = 0;
        
        for (const key in $scope.checkboxCategory) {
            if (Object.hasOwnProperty.call($scope.checkboxCategory, key)) {
                const element = $scope.checkboxCategory[key];
                if (element === true) {
                    checkCount += $scope.categoryReport[key].count;
                }
            }
        }

        if (checkCount > 0) {

            if (checkCount === $scope.products.length) {
                checkAllProductEl.indeterminate = false;
                checkAllProductEl.checked = true;
            } else {
                checkAllProductEl.indeterminate = true;
            }
            
        } else if (checkCount === 0) {
            checkAllProductEl.indeterminate = false;
        }

        $scope.states.checkCount = checkCount;
    }

    $scope.range = function (min, max, step) {
        step = step || 1;
        var input = [];
        for (var i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    $scope.getProducts = getProducts;
        
    function reset() 
    {
        $scope.products = [];

        $scope.states = {
            isLoading: true
        }
    }

    function getProducts()
    {
        reset();

        $scope.states.isLoading = true;
        $scope.products = [];
      
        const filters = {
            staffId: ($scope.filters.staff) ? $scope.filters.staff : '',
            page: $scope.productPagination.current_page,
            fromDate: $scope.filters.fromDate ? $scope.filters.fromDate: '',
            toDate: $scope.filters.toDate ? $scope.filters.toDate : '',
            reason: $scope.filters.reason ? $scope.filters.reason: ''
        }

        const params = new URLSearchParams(filters).toString();

        $http.get('/module/ads/pedding-products/get-products?' + params).then((response) => 
        {
            $scope.products = response.data.data;

            $scope.productPagination.number_page = response.data.last_page;
            $scope.productPagination.page_size = response.data.per_page;

            document.getElementById('tableProduct').scrollIntoView();

            $scope.states.isLoading = false;
        });
    }

    $scope.chooseStaff = function(staff) {

        $scope.filters.staff = staff.user_id;

        getProducts();
    }

    function getStaffProductCount()
    {
        $http.get('/module/ads/pedding-products/get-staff-product-count').then((response) => 
        {
            const halfLength = Math.floor(response.data.length / 2);

            $scope.staffProductCount = response.data.slice(0, halfLength);
            $scope.staffProductCountSecond = response.data.slice(halfLength);
        });
    }

    function init()
    {
        getProducts();
        getStaffProductCount();
        
        // event
        document.addEventListener('error', function (event) {
            var elm = event.target;
            if (elm.tagName == 'IMG') {
                elm.src = "https://via.placeholder.com/200x200.png?text=Product%20Image";
            }
        }, true );

    }

    function safeApply() {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }

    init();

}