system.controller("ProductCategoryActivitiesController", ProductCategoryActivitiesController);

system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductCategoryActivitiesController($rootScope, $scope, $http) {

    $scope.isShowLoading = true;
    $scope.baseUrl = base_url;
    $scope.sorts = [
        { code: "product_rate,SORT_ASC", name: "Tỉ lệ chuyển đổi tăng dần" },
        { code: "product_rate,SORT_DESC", name: "Tỉ lệ chuyển đổi giảm dần" },
        { code: "total_click,SORT_ASC", name: "Click tăng dần" },
        { code: "total_click,SORT_DESC", name: "Click giảm dần" },
        { code: "total_conversion,SORT_ASC", name: "Đơn hàng tăng dần" },
        { code: "total_conversion,SORT_DESC", name: "Đơn hàng giảm dần" }
    ];
    $scope.dataSources = [
        { name: 'Quảng cáo', code: 'ads' },
        { name: 'SEO', code: 'seo' },
    ];
    $scope.filter = {
        pageId: 0,
        orderFrom: 0,
        clickFrom: 200,
        inventoryFrom: 0,
    };
    $scope.sellers = [
        {
            name: 'Tất cả',
            value: 0
        },
        {
            name: 'Chiaki',
            value: 1
        },
        {
            name: 'Seller',
            value: 2
        },
    ];

    this.initialize = function() {
        this.initDatePicker();
        this.initalFilters();
        $scope.find();
    }

    $scope.reset = function () {
        $(".datepicker").datepicker({
            dateFormat: "dd/mm/yy"
        });
        var today = new Date();
        var oneMonthAgo = new Date();
        oneMonthAgo.setDate(today.getDate() - 30);
        $scope.filter.orderDateFrom = oneMonthAgo;
        $scope.filter.orderDateTo = today;
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.search = '';
        $scope.filter.page_id = 0;
        $scope.filter.orderFrom = 0;
        $scope.filter.clickFrom = 200;
        $scope.filter.inventoryFrom = 0;
        $scope.find();
    };

    $scope.dayTimestamp = function (dateString) {
        var arr = dateString.split("/");
        arr.reverse();
        var string = arr.join("-");
        var dateTime = new Date(string);
        dateTime.setHours(0);
        dateTime.setMinutes(0);
        dateTime.setSeconds(0);
        dateTime.setMilliseconds(0);
        return dateTime.getTime() / 1000;
    };

    $scope.typeSearch = function() {
        clearTimeout($scope.typingTimeout);
        $scope.typingTimeout = setTimeout(function () {
            $scope.find(true);
        }, $scope.waitTyping); 
    }

    /**
     * find data by filter
     * @returns {undefined}
     */
    $scope.find = function (isChangePageData) {
        $scope.isFinding = true;
        if (isChangePageData) {
            $scope.filter.page_id = 0;
        }
        var dataFilter = builFilterData();
        if($scope.filter.clickFrom < 1){
            $scope.filter.clickFrom = 1;
            alert("Số lượt click phải lớn hơn 0");
            return;
        }
        $scope.showLoading(true);
        $http.get("/product-react/service/find-product-low-rate", {
            params: {
                orderDateFrom: dataFilter.orderDateFrom,
                orderDateTo: dataFilter.orderDateTo,
                order: dataFilter.sort,
                pageId: $scope.filter.page_id,
                pageSize: 200,
                search: $scope.filter.search,
                clickFrom: $scope.filter.clickFrom ,
                inventoryFrom: $scope.filter.inventoryFrom,
                isExportExcel: $scope.isExportExcel,
                only_product: onlyProduct
            }
        }).then(function (result) {
            var data = result.data;
            $scope.showLoading(false);
            $scope.isFinding = false;
            if (data.status == "successful") {
                $scope.items = data.items;
                $scope.pagesCount = data.pagesCount;
                $scope.filter.page_id = parseInt(data.pageId);
            }
        })
            .catch(function () {
                $scope.showLoading(false);
                alert("Không thể tải danh sách, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật để được hỗ trợ.");
                $scope.isSaving = false;
            });
    };

    $scope.getExcel = function () {
        var params = builFilterData();
        params.order = params.sort;
        var urlParams = '';
        for (var key in params) {
            if (urlParams != '') {
                urlParams += "&";
            }
            urlParams += key + "=" + encodeURIComponent(params[key]);
        }
        var url = '/product-react/service/export-product-low-rate?' + urlParams;
        window.open(url, '_blank');

    };

    $scope.showLoading = function(val) {
        $scope.isShowLoading = val;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        var day = (date.getDate() > 9) ? date.getDate() : '0' + date.getDate();
        var month = ((date.getMonth() + 1) > 9) ? date.getMonth() + 1 : '0' + (date.getMonth() + 1);
        var year = date.getFullYear();
        if (formatString == 'dd/mm/yyyy') {
            return `${day}/${month}/${year}`;
        }
        return `${month}/${day}/${year} ${strTime}`;
    }

    function builFilterData() {
        var retVal = {
            page_id: $scope.filter.page_id
        };

        if (typeof $scope.filter.trackingParam != 'undefined') {
            retVal.source = $scope.filter.trackingParam.key;
        }
        if (typeof $scope.filter.sort != 'undefined') {
            retVal.sort = $scope.filter.sort.code;
        }
        if ($scope.filter.orderDateFrom != 'undefined') {
            retVal.orderDateFrom = formatDate($scope.filter.orderDateFrom, 'dd/mm/yyyy');
        }
        if ($scope.orderDateTo != 'undefined') {
            retVal.orderDateTo = formatDate($scope.filter.orderDateTo, 'dd/mm/yyyy');
        }
        if ($scope.filter.search) {
            retVal.search = $scope.filter.search;
        }
        retVal.orderFrom = $scope.filter.orderFrom;
        retVal.clickFrom = $scope.filter.clickFrom;
        retVal.inventoryFrom = $scope.filter.inventoryFrom;
        retVal.seller = $scope.filter.seller.value;
        return retVal;
    }


    this.initDatePicker = function() {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);
        $scope.filter.orderDateTo = new Date();
    }

    this.initalFilters = function() {
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.seller = $scope.sellers[0];
    }

    this.initialize();
}
