system.controller("ProductIncorrectLanguageController", ProductIncorrectLanguageController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductIncorrectLanguageController($scope, $http, $rootScope) {
    this.__proto__ = new BaseController($scope, $http, $rootScope);
    this.__proto__ = new PaginationController($scope, $http, $rootScope);
    $scope.controllerName = "ProductIncorrectLanguageController";
    $scope.items = [];
    $scope.tabs = [
        {
            name: "Danh sách",
            type: 'list',
            active: true
        },
        {
            name: "Import",
            type: 'import',
            active: false
        },
        {
            name: "Translation",
            type: 'translation',
            active: false
        },
        {
            name: "Update to product",
            type: 'update',
            active: false
        }
    ];
    $scope.filter = {};
    $scope.locales = PODLocales;
    $scope.currentLocale = currentLocale;
    $scope.translated = 0;
    $scope.updated = 0;
    this.initialize = function () {
        $scope.meta = {
            page_id: 0,
            page_size: 100,
        };
        $scope.find();
    };

    $scope.reset = function () {
        $scope.filter = {};
        $scope.find();
    };

    $scope.find = function () {
        let apiUrl = ($scope.currentLocale !== 'us' ? $scope.currentLocale : '') + "/ads/incorrect-language/find";
        var url = $scope.buildAdvertisingUrl(apiUrl);

        let filter = $scope.buildFilter();
        var params = getParams(filter);

        if (params.length > 0) {
            url += "&" + params.join("&");
        }

        $http.get(url).then(function successCallback(response) {
            if (response.data.status == "successful") {
                var result = response.data.result;
                $scope.meta = response.data.meta;
                $scope.items = result;
            }
        }, function error() {
            toastr.error("Bạn không có quyền sử dụng dịch vụ!");
        });
    };

    $scope.buildFilter = () => {
        let retVal = {};
        if ($scope.filter.sku && $scope.filter.sku != "") {
            retVal.sku = $scope.filter.sku;
        }
        if ($scope.filter.name && $scope.filter.name != "") {
            retVal.name = $scope.filter.name;
        }
        if ($scope.filter.translate_name && $scope.filter.translate_name != "") {
            retVal.translate_name = $scope.filter.translate_name;
        }
        if ($scope.filter.is_update) {
            retVal.is_update = $scope.filter.is_update;
        }
        if ($scope.filter.is_translate) {
            retVal.is_translate = $scope.filter.is_translate;
        }
        retVal.token = 'VVCTTQUhXuPCKYu';
        return retVal;
    }

    $scope.buildAdvertisingUrl = (url) => {
        url = $scope.buildFilterUrl(url);
        url = $scope.buildPaginationUrl(url, $scope.customPageSize);
        return url;
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.keypressFilter = function (event) {
        if (event.keyCode == 13) {
            $scope.filter.pageId = 0;
            $scope.find();
        }
    };

    $scope.startTranslating = function () {
        var url = ($scope.currentLocale !== 'us' ? $scope.currentLocale : '')
            + "/ads/incorrect-language/translate?token=VVCTTQUhXuPCKYu";
        $http.get(url)
            .then((res) => {
                if (res.data.status == 'successful') {
                    $scope.translated += parseInt(res.data.total);
                }
            })
            .catch((err) => console.log(err));
    }

    $scope.startUpdateToProduct = function () {
        var url = ($scope.currentLocale !== 'us' ? $scope.currentLocale : '')
            + "/ads/incorrect-language/update-to-product?token=VVCTTQUhXuPCKYu";
        $http.get(url)
            .then((res) => {
                if (res.data.status == 'successful') {
                    $scope.updated += parseInt(res.data.total);
                }
            })
            .catch((err) => console.log(err));
    }

    var getParams = function (filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = "";
            if (typeof filterValue == "object" || typeof filterValue == "array") {
                if (filterValue.length > 0) {
                    param = key + "=" + filterValue.join(",");
                }
            } else {
                param = key + "=" + filterValue;
            }
            if (param!= "") {
                params.push(param);
            }
        }
        return params;
    }

    this.initialize();
}
