system.controller("ProductPriceController", ProductPriceController);


class TaskQueue {
    constructor(concurrency = 1, name = 'default', showRunningLog = true) {
        this.concurrency = concurrency;
        this.running = 0;
        this.name = name;
        this.queue = [];
        this.showRunningLog = showRunningLog;
    }

    pushTask(task) {
        this.queue.push(task);
        this.next();
    }

    priority(task) {
        this.queue.unshift(task);
        this.next();
    }

    size() {
        return this.queue.length;
    }
    getRunning() {
        return this.running;
    }

    clear() {
        this.queue = [];
    }

    waitDone() {
        return new Promise((resolve, reject) => {
            setTimeout(() => {
                let interval = setInterval(() => {
                    console.log('this.getRunning()', this.getRunning());
                    if(this.getRunning() <= 0) {
                        clearInterval(interval);
                        resolve();
                    }
                }, 1000);
            }, 1000);
        })
    }

    next() {
        const self = this;
        while (this.running < this.concurrency && this.queue.length) {
            const task = this.queue.shift();
            self.running++;
            console.log(this.name, 'running: ', this.running, 'length: ', this.queue.length);
            task().then((callback) => {
                self.running--;
                if (self.showRunningLog) {
                    console.log(this.name, 'running: ', this.running, 'length: ', this.queue.length);
                }
                self.next();
                if (typeof callback == 'function') {
                    callback();
                }

            }).catch(function(e) {
                self.running--;
                self.next();
                console.log('error', self.name, e.message);
            });
        }
    }
};


function ProductPriceController($scope, $http, $rootScope) {
    $scope.products = [];
    $scope.saving = false;
    $scope.logs = [];
    $scope.btnText = 'Cập nhật';
    $scope.errorCount = 0;
    $scope.successCount = 0;

    $scope.loadFile = async function ($files) {
        if (!$files || !$files.length) {
            return;
        }
        $scope.$applyAsync(() => {
            $scope.saving = true;
            $scope.btnText = 'Đang đọc file';
        })
        const file = $files[0];
        var reader = new FileReader();
        $scope.products = await new Promise((resolve, reject) => {
            let fileExt = $scope.getFileExtension(file.name);
            reader.onload = function(e) {
                let content = e.target.result;
                let products = $scope.processData(content, fileExt);
                resolve(products);
            };
            if (fileExt == 'csv') {
                reader.readAsText(file);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                reader.readAsBinaryString(file);
            }
        });
        $scope.$applyAsync(function () {
            $scope.saving = false;
            $scope.btnText = 'Cập nhật';
        })
    }

    $scope.getFileExtension = (filename) => {
        var ext = /^.+\.([^.]+)$/.exec(filename);
        return ext == null ? "" : ext[1];
    }

    $scope.processData = (content, fileExt) => {
        let objects = [];
        try {
            if (fileExt == 'csv') {
                objects = $.csv.toObjects(content);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                let workbook = XLSX.read(content, {
                    type: 'binary'
                });
                workbook.SheetNames.forEach(sheet => {
                    let arrayObject = XLSX.utils.sheet_to_row_object_array(
                        workbook.Sheets[sheet]
                    );
                    objects = objects.concat(arrayObject);
                });
            }
        } catch (ex) {
            console.log(ex);
            $scope.showErrorModal('Không thể đọc được file.');
        }
        
        return objects;
    }

    $scope.update = async () => {
        $scope.errorCount = 0;
        $scope.successCount = 0;

        const queueConcurrency = 10;
        const queueName = 'queue';
        const queue = new TaskQueue(queueConcurrency, queueName)

        $scope.saving = true;
        let itemsByLocale = {};
        for (let item of $scope.products) {
            if (!item['Countries']) {
                continue;
            }
            let locale = item['Countries'].toLowerCase().trim();
            if (locale == 'gb') {
                locale = 'uk';
            }
            if (!itemsByLocale[locale]) {
                itemsByLocale[locale] = [];
            }
            itemsByLocale[locale].push(item['Item ID']);
        }

        let siteUrl = window.location.origin;
        for (let locale in itemsByLocale) {
            let apiUrl = base_api_url.replace(/(\w+|)(\.|)api/, `${locale}.api`);
            let restQUrl = apiUrl.replace(`${locale}.api.`, 'q.');
            let chunks = $scope.arrayChunks(itemsByLocale[locale], 50);
            for (let chunk of chunks) {
                let task = () => {
                    $scope.$applyAsync(() => {
                        if ($scope.logs.length > 10) {
                            $scope.logs = $scope.logs.slice(-10);
                        }
                        $scope.logs.push(queue.name + ': running: ' + queue.running + ', length: ' + queue.queue.length);
                    })
                    return $http.get(`${restQUrl}/v2/cron/build-product-info?ignore_localization=1&service_token=megaads@123&skus=${chunk.join(',')}&call_merchant_update=1&locale=${locale}`)
                        .then(res => {
                            $scope.successCount++;
                        }, err => {
                            $scope.errorCount++;
                            toastr.error('Đã có lỗi xảy ra');
                        })
                }

                queue.pushTask(task);
            }
        }

        await queue.waitDone();
        $scope.$applyAsync(() => {
            $scope.saving = false;
            toastr.success('Cập nhật thành công');
        })

    }

    $scope.arrayChunks = (array, size = 100) => {
        let chunks = [];
        for (let i = 0; i < array.length; i++) {
            let chunk = [];
            let j = i;
            let limit = i + size;
            for (j = i; j < array.length && j < limit; j++) {
                chunk.push(array[j]);
            }
            i = j - 1;
            chunks.push(chunk);
        }
        
        return chunks;
    }
}
