system.controller("ProductInteractionController", ProductInteractionController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductInteractionController($rootScope, $scope, $http) {
    
    var self = this;
    $scope.orderDateFrom;
    $scope.orderDateTo;
    $scope.isShowLoading = true;
    $scope.baseUrl = base_url;
    $scope.filter = {
        pageId: 0,
        orderFrom: 0,
        clickFrom: 10,
        adwordsClickFrom: 0,
        bingadsClickFrom: 0,
        organicClickFrom: 0,
        inventoryFrom: 0,
    };
    $scope.sorts = [
        { code: "rate,asc", name: "Tỉ lệ chuyển đổi tăng dần" },
        { code: "rate,desc", name: "Tỉ lệ chuyển đổi giảm dần" },
        { code: "total_conversion,asc", name: "Đơn hàng tăng dần" },
        { code: "total_conversion,desc", name: "Đơn hàng giảm dần" },
        { code: "total_click,desc", name: "Tổng click giảm dần" },
        { code: "total_click,asc", name: "Tổng click tăng dần" },
        { code: "adwords_click,desc", name: "Adwords click giảm dần" },
        { code: "adwords_click,asc", name: "Adwords click tăng dần" },
        { code: "organic_click,desc", name: "Organic click giảm dần" },
        { code: "organic_click,asc", name: "Organic click tăng dần" },
    ];
    $scope.dataSources = [
        { name: 'Quảng cáo', code: 'ads' },
        { name: 'SEO', code: 'seo' },
    ];

    $scope.sellers = [
        {
            name: 'Tất cả',
            value: 0
        },
        {
            name: 'Chiaki',
            value: 1
        },
        {
            name: 'Seller',
            value: 2
        },
    ];
    $scope.items = [];
    $scope.adsGlobalMsg = '';
    $scope.adsGlobalConfig = {
        click_from: 1,
        order_from: 0,
        conversion_rate: 1,
        term: 15,
    };
    $scope.adsProductConfig = {
        click_from: 1,
        order_from: 0,
        conversion_rate: 1,
        term: 15,
        product_id: 0,
        product_name: '',
    };



    this.initialize = function() {
        this.initDatePicker();
        this.initalFilters();
        $scope.find();
        initConfigGlobal()
        $scope.generateAdsGlobalMsg();

    }


    /**
     * find data by filter
     * @returns {undefined}
     */
     $scope.find = function (isChangePageData) {
        $scope.isFinding = true;
        $scope.isShowHideLoading(true);
        if (isChangePageData) {
            $scope.filter.page_id = 0;
        }
        $scope.items = [];
        var dataFilter = self.builFilterData();
        $http.get("/product-react/service/find", {
            params: {
                orderDateFrom: dataFilter.orderDateFrom,
                orderDateTo: dataFilter.orderDateTo,
                order: dataFilter.sort,
                pageId: $scope.filter.page_id,
                pageSize: 100,
                search: $scope.filter.search,
                orderFrom: $scope.filter.orderFrom,
                clickFrom: $scope.filter.clickFrom,
                adwordsClickFrom: $scope.filter.adwordsClickFrom,
                organicClickFrom: $scope.filter.organicClickFrom,
                bingadsClickFrom: $scope.filter.bingadsClickFrom,
                inventoryFrom: dataFilter.inventoryFrom,
                seller: dataFilter.seller,
                only_product: onlyProduct
            }
        }).then(function (result) {
            var data = result.data;
            $scope.isFinding = false;
            if (data.status == "successful") {
                listTemp = data.items;
                listTemp.forEach(el => {
                    if (!el.inventory) {
                        el.inventory = 0;
                    }
                });
                $scope.items = listTemp;
                $scope.isShowHideLoading(false);
                
                $scope.pagesCount = data.pagesCount;
                $scope.filter.page_id = parseInt(data.pageId);
            }
        })
        .catch(function () {
            $scope.isShowHideLoading(true);
            alert("Không thể tải danh sách, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật để được hỗ trợ.");
            $scope.isSaving = false;
        });
    };


    $scope.reset = function () {
        $(".datepicker").datepicker({
            dateFormat: "dd/mm/yy"
        });
        var today = new Date();
        var oneMonthAgo = new Date();
        oneMonthAgo.setDate(today.getDate() - 30);
        $scope.orderDateFrom = new Date(oneMonthAgo);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);
        var lastDay = new Date();
        lastDay.setDate(lastDay.getDate() - 1);
        $scope.filter.orderDateTo = lastDay;
        $scope.orderDateTo =lastDay;
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.search = '';
        $scope.filter.page_id = 0;
        $scope.filter.orderFrom = 0;
        $scope.filter.clickFrom = 10;
        $scope.filter.adwordsClickFrom = 0;
        $scope.filter.organicClickFrom = 0;
        $scope.filter.bingadsClickFrom = 0;
        $scope.filter.inventoryFrom = 0;
        $scope.find();
        $scope.generateAdsGlobalMsg();
    };

    $scope.turnOffAds = function (item) {
        item.advertising_status = !item.advertising_status;
        if(item.advertising_status) {
            var confirmChange = confirm("Bật quảng cáo có liên quan tới sản phẩm");
        }
        else {
            var confirmChange = confirm("Tắt quảng cáo có liên quan tới sản phẩm");
        }
        if (!confirmChange) {
            $scope.find();
            return false;
        }
        var status = item.advertising_status ? 1 : 0;


        $http.post('/product-react/service/config/ads-status', {
           product_id: item.product_id,
           status: status,
        }).then(response => {
            if (response.data.status == "successful") {
                toastr.success("Cập nhật thành công.");
            } else {
                toastr.error("Có lỗi xảy ra, xin thử lại");
            }
            $scope.find();
        }, function error() {
            toastr.error("Bạn không có quyền sử dụng dịch vụ!");
        });
    };

    $scope.getExcel = function () {
        var params = self.builFilterData();
        params.order = params.sort;
        var urlParams = '';
        for (var key in params) {
            if (urlParams != '') {
                urlParams += "&";
            }
            urlParams += key + "=" + encodeURIComponent(params[key]);
        }
        var url = prefixLocaleUrl + 'product-react/service/export?' + urlParams;
        window.open(url, '_blank');
    };

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    this.initDatePicker = function() {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);

        var lastDay = new Date();
        lastDay.setDate(lastDay.getDate() - 1);
        $scope.filter.orderDateTo = lastDay;
    }

    this.initalFilters = function() {
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.seller = $scope.sellers[0];
    }

    this.builFilterData = function() {
        var retVal = {
            page_id: $scope.filter.page_id
        };

        if (typeof $scope.filter.trackingParam != 'undefined') {
            retVal.source = $scope.filter.trackingParam.key;
        }
        if (typeof $scope.filter.sort != 'undefined') {
            retVal.sort = $scope.filter.sort.code;
        }
        if ($scope.filter.orderDateFrom != 'undefined') {
            retVal.orderDateFrom = formatDate($scope.filter.orderDateFrom, 'dd/mm/yyyy'); //$scope.dayTimestamp(orderDateFrom);
        }
        if ($scope.orderDateTo != 'undefined') {
            retVal.orderDateTo = formatDate($scope.filter.orderDateTo, 'dd/mm/yyyy'); // $scope.dayTimestamp(orderDateTo);
        }
        if ($scope.filter.search) {
            retVal.search = $scope.filter.search;
        }
        retVal.orderFrom = $scope.filter.orderFrom;
        retVal.clickFrom = $scope.filter.clickFrom;
        retVal.adwordsClickFrom = $scope.filter.adwordsClickFrom;
        retVal.organicClickFrom = $scope.filter.organicClickFrom;
        retVal.bingadsClickFrom = $scope.filter.bingadsClickFrom;
        retVal.inventoryFrom = $scope.filter.inventoryFrom;
        retVal.seller = $scope.filter.seller.value;
        retVal.only_product = onlyProduct;
        return retVal;
    }

    $scope.editGlobalConfig = function () {
        $scope.generateAdsGlobalMsg();
        $('#js-advertising-global-modal').modal('show');

    }

    $scope.editProductConfig = function (item) {
        $scope.adsProductConfig = item.ads_config;
        $scope.adsProductConfig.product_id = item.product_id;
        $scope.adsProductConfig.product_name = item.name;
        $scope.adsProductConfig.product_slug = item.slug;
        $('#js-advertising-product-modal').modal('show');

    }

    $scope.saveAdsGlobalConfig = function () {
        $http.post('/product-react/service/config/global', $scope.adsGlobalConfig).then(function(res) {
            if (res.data && res.data.status == 'successful') {
                $('#js-advertising-global-modal').modal('hide');
            } else {
                toastr.error("Có lỗi xảy ra, xin thử lại");
            }
        })
    }

    $scope.saveAdsProductConfig = function () {
        $http.post('/product-react/service/config/product', $scope.adsProductConfig).then(function(res) {
            if (res.data && res.data.status == 'successful') {
                $('#js-advertising-product-modal').modal('hide');
                for (let item of $scope.items) {
                    if (item.product_id == $scope.adsProductConfig.product_id) {
                        item.click_from =  $scope.adsProductConfig.click_from;
                        item.order_from =  $scope.adsProductConfig.order_from;
                        item.conversion_rate =  $scope.adsProductConfig.conversion_rate;
                        item.term =  $scope.adsProductConfig.term;
                        item.ads_is_config =  1;
                    }
                }
            } else {
                toastr.error("Có lỗi xảy ra, xin thử lại");
            }
        })
    }

    $scope.generateAdsGlobalMsg = function () {
        let result = '';
        if ($scope.adsGlobalConfig.term > 0 && $scope.adsGlobalConfig.conversion_rate !== null && $scope.adsGlobalConfig.conversion_rate >= 0) {
            result = `*Trong 1 kỳ ${$scope.adsGlobalConfig.term} ngày những sản phẩm có `
            if ($scope.adsGlobalConfig.click_from > 0) {
                result += ' tổng click > ' + $scope.adsGlobalConfig.click_from + ','
            }
            if ($scope.adsGlobalConfig.order_from > 0) {
                result += ' đơn hàng > ' + $scope.adsGlobalConfig.order_from + ','
            }
            result += ' tỉ lệ chuyển đổi < ' + $scope.adsGlobalConfig.conversion_rate + '% sẽ bị tắt quảng cáo';
        }
        $scope.adsGlobalMsg = result;

    }

    function initConfigGlobal() {
        findConfig({}, function (res) {
            if (res.data && res.data.status == 'successful') {
                $scope.adsGlobalConfig = res.data.data;
            }
        })
    }


    function findConfig(params, callback) {
        $http.get('/product-react/service/config/find', params).then(callback)
    }

    this.initialize();
}