system.controller("ProductRunAdsController", ProductRunAdsController);

function ProductRunAdsController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);

    $scope.filters = {
        product_id: "",
    };

    $scope.isSelectedAll = false;
    $scope.selectedProductLength = 0;
    $scope.loading = false;
    $scope.productIds = '';
    $scope.productLinks = ``;

    $scope.initialize = () => {
        $scope.filters.dateFrom = $scope.formatFilterDate((new Date((new Date()).getTime() - 2 * 86400 * 1000)));
        $scope.filters.dateTo = $scope.formatFilterDate(new Date());

        $scope.find();
    }

    $scope.$watch('productLinks', (newValue) => {
        let rows = newValue.split(/\n+/gm);
        let productIds = [];
        let currentLocale = typeof localeCode != 'undefined' && localeCode ? localeCode : 'us';
        for (let row of rows) {
            if (!row.trim()) {
                continue;
            }
            let match = row.trim().match(/\/([a-z]{2})\//);
            let locale = 'us';
            if (match && match.length > 1) {
                locale = match[1];
            }
            if (locale != currentLocale) {
                continue;
            }
            let productId = row.trim().split('?')[0].replace(/(.*-p|^p)(\d+).*/gmi, '$2').trim();
            if (productId) {
                productIds.push(productId);
            }
        }

        $scope.productIds = productIds.join(',');
    });

    $scope.formatFilterDate = (date) => {
        return date.toISOString().slice(0, 10).replace('T', ' ').split('-').reverse().join('/');
    }

    $scope.reset = () => {
        $scope.meta.page_id = 0;
        $scope.filters = {
            product_id: "",
            is_hide_ads: 0,
            is_push_ads: 0,
            status: 'PENDING'
        };

        $scope.filters.dateFrom = $scope.formatFilterDate((new Date((new Date()).getTime() - 2 * 86400 * 1000)));
        $scope.filters.dateTo = $scope.formatFilterDate(new Date());
    
        $scope.find(true);
    }


    $scope.find = (refresh = false) => {
        $scope.resetSelectedProducts();

        if (refresh) {
            $scope.meta.page_id = 0;
        }

        $scope.products = [];
        $scope.loading = true;
        let filterStr = Object.keys($scope.filters).filter(key => key.indexOf('date') < 0 && $scope.filters[key] !== null).map(key => `${key}=${$scope.filters[key]}`).join('&');

        if ($scope.filters.dateFrom) {
            filterStr += `&date_from=${$scope.vietnameseTimeToSQLTime($scope.filters.dateFrom) + " 00:00:00"}`;
        }

        if ($scope.filters.dateTo) {
            filterStr += `&date_to=${$scope.vietnameseTimeToSQLTime($scope.filters.dateTo) + " 23:59:59"}`;
        }

        $http.get(`/ads/product-run-ads/find?page_id=${$scope.meta.page_id}&${filterStr}`)
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.products = res.data.result;
                    for (let key in $scope.products) {
                        $scope.products[key].url = $scope.getProductUrl($scope.products[key]);
                    }
                    $scope.meta = res.data.meta;
                    if (res.data.result.length < $scope.meta.page_size) {
                        $scope.meta.page_count = $scope.meta.page_id + 1;
                        $scope.meta.has_next = false;
                    } else {
                        $scope.meta.page_count = $scope.meta.page_id + 5;
                    }
                    $scope.meta.hide_page_count = 1;
                }
                $scope.loading = false;
            }, err => {
                console.log(err);
                $scope.loading = false;
            })
    }

    $scope.getProductUrl = (product) => {
        return `${localePrefix && localePrefix != defaultLocale ? `/${localePrefix}/` : '/'}${product.slug}-p${product.product_id}`;
    }

    $scope.addSelectedProducts = function (index) {
        $scope.products[index].selected = !$scope.products[index].selected;
        if ($scope.products[index].selected) {
            $scope.selectedProductLength++
        } else {
            $scope.selectedProductLength--;
        }
        $scope.isSelectedAll = $scope.checkSelectedAll()
    };

    $scope.resetOrCheckAll = function () {
        for (let index in $scope.products) {
            $scope.products[index].selected = $scope.isSelectedAll;
        }
        $scope.selectedProductLength = $scope.isSelectedAll ? $scope.products.length : 0;
    }

    $scope.resetSelectedProducts = () => {
        $scope.isSelectedAll = 0;
        $scope.selectedProductLength = 0;
    }

    $scope.checkSelectedAll = function () {
        return !$scope.products.find(item => !item.selected);
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.save = function (item) {
        if (!$scope.productIds.split(',').length) {
            toastr.error('Vui lòng nhập sản phẩm');
            return;
        }
        $http.post(`/ads/product-run-ads`, {
            product_ids: $scope.productIds,
        }).then(res => {
            if (!res.data.status || res.data.status !== 'successful') {
                toastr.error('Đã có lỗi xảy ra');
            } else {
                toastr.success('Thêm thành công');
                $scope.find(true);
                $scope.hideAddModal();
            }
        }, err => {
            toastr.error('Đã có lỗi xảy ra');
        })
    }

    $scope.deleteBulk = function () {
        $scope.callConfirmModal({
            title: 'Xóa sản phẩm',
            text: "xóa sản phẩm"
        }, function() {
            productIds = $scope.products.filter(item => item.selected).map(item => item.product_id);

            $http.post("/ads/product-run-ads/bulk-delete", {
                product_ids: productIds.join(','),
            }).then((res) => {
                if (res.data.status === 'successful') {
                    toastr.success("Xóa thành công");

                    $scope.products = $scope.products.filter(item => !item.selected);
                    $scope.resetSelectedProducts();
                }
            })
            .catch((e) => {
                toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
            });
        });
    }

    $scope.delete = function (item, index) {
        $scope.callConfirmModal({
            title: 'Xóa sản phẩm',
            text: "xóa sản phẩm"
        }, function() {
            $http.delete("/ads/product-run-ads/" + item.id).then((res) => {
                    if (res.data.status === 'successful') {
                        toastr.success("Xóa thành công");

                        $scope.products.splice(index, 1);
                    }
                })
                .catch((e) => {
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }

    $scope.showAddModal = function () {
        $scope.productIds = '';
        $scope.productLinks = ``;
        $('#add-modal').modal('show');
    }

    $scope.hideAddModal = function () {
        $('#add-modal').modal('hide');
    }

    $scope.initialize();
}