system.controller("ProductSoldOffAdsController", ProductSoldOffAdsController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductSoldOffAdsController($rootScope, $scope, $http, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.products = [];
    $scope.filter = {
        page_id: 0,
        page_size: 100,
        orderDateFrom: "",
        orderDateTo: "",
        status: "-1"
    }
    $scope.orderDateFrom;
    $scope.orderDateTo;
    $scope.loading = false;
    $scope.isSelectAll = false;
    $scope.countSelectedQuantity = 0;

    $scope.productUrl = (product) => {
        return  base_url + "/" + (product.slug ? product.slug : "san-pham") + "-p" + product.id + ".html";
    }

    $scope.changePage = (page) => {
        $scope.find(page);
    };

    $scope.initialize = function () {
        $scope.initDatePicker();
        $scope.find();
    };

    $scope.find = (refresh = false) => {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        $scope.loading = true;
        var dataFilter = $scope.builFilterData();
        if (!dataFilter.orderDateFrom || !dataFilter.orderDateTo) {
            alert("Vui lòng chọn ngày bắt đầu và kết thúc");
            $scope.loading = false;
            safeApply();
            return;
        }
        let params = {
            orderDateFrom: dataFilter.orderDateFrom,
            orderDateTo: dataFilter.orderDateTo,
            pageId: $scope.filter.page_id,
            pageSize: $scope.filter.page_size
        };
        if (dataFilter.keyword) {
            params.keyword = dataFilter.keyword;
        }
        if (dataFilter.status) {
            params.status = dataFilter.status;
        }
        $http.post('/ads/product-sold-off-ads/get-products', params).then((response) => {
            for (let index = 0; index < response.data.items.length; index++) {
                const element = response.data.items[index];
                element.selected = false;
                element.textBtn = "Duyệt quảng cáo";
                element.isApprove = false;
                element.className = "btn btn-success";
            }
            $scope.products = response.data.items;
            $scope.pagesCount = response.data.pagesCount;
            $scope.loading = false;

            safeApply();
            
        }).catch((err) => {
            $scope.loading = false;
        });
    };

    const safeApply = () => {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }

    $scope.initDatePicker = function() {
        $(".datepicker").datepicker({
            dateFormat: "dd/mm/yy"
        });
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 3);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);

        var lastDay = new Date();
        $scope.filter.orderDateTo = lastDay;
    }

    $scope.builFilterData = function() {
        var retVal = {
            pageId: $scope.filter.page_id
        };
        if ($scope.filter.orderDateFrom != 'undefined') {
            retVal.orderDateFrom = formatDate($scope.filter.orderDateFrom, 'dd/mm/yyyy');
        }
        if ($scope.filter.orderDateTo != 'undefined') {
            retVal.orderDateTo = formatDate($scope.filter.orderDateTo, 'dd/mm/yyyy');
        }
        if ($scope.filter.keyword != 'undefined' && $scope.filter.keyword != '') {
            retVal.keyword = $scope.filter.keyword;
        }
        if ($scope.filter.status != 'undefined' && $scope.filter.status != '') {
            retVal.status = $scope.filter.status;
        }

        return retVal;
    }

    $scope.reset = function () {
        $(".datepicker").datepicker({
            dateFormat: "dd/mm/yy"
        });
        var today = new Date();
        var oneMonthAgo = new Date();
        oneMonthAgo.setDate(today.getDate() - 30);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);
        var lastDay = new Date();
        lastDay.setDate(lastDay.getDate() - 1);
        $scope.filter.orderDateTo = lastDay;
        $scope.filter.status = "-1";
        $scope.filter.keyword = "";
        $scope.filters = {
            page_id: 0,
        }
        $scope.isSelectAll = false;
        $scope.find(true);
    };

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.autoApproveAdvertising = function (ids, product) {
        $http({
            method: 'GET',
            url: '/module/ads/merchant/insert',
            params: {
                ids: ids,
                ignore_updated_at: 1,
            }
        }).then(function success(response) {
            if (response.data.status === 'successful') {
                if (response.data.message.status === 'fail') {
                    toastr.error('Duyệt quảng cáo thất bại. ' + response.data.message.message);
                } else {
                    toastr.success(response.data.message.message);
                    if (product) {
                        product.textBtn = 'Đã duyệt quảng cáo';
                        product.className = 'btn btn-secondary';
                        product.isApprove = true;
                    } else {
                        for (let index = 0; index < $scope.products.length; index++) {
                            const element = $scope.products[index];
                            if (element.selected) {
                                element.textBtn = 'Đã duyệt quảng cáo';
                                element.className = 'btn btn-secondary';
                                element.isApprove = true;
                                element.selected = false;
                            }
                        }
                        $scope.countSelectedQuantity = 0;
                    }
                }
                // $scope.find(true);
            } else {
                toastr.error('Duyệt quảng cáo thất bại. ' + response.data.message.message)
            }
        });
    }

    $scope.onChangeApproveAdvertising = function (product) {
        $http({
            method: 'POST',
            url: base_api_url + '/product/approve-advertising',
            data: {
                product_id: product.id,
                status: true,
            }
        }).then(function success(response) {
            if (response.data.status === 'successful') {
                toastr.success('Bật quảng cáo thành công');
                setTimeout(function () {
                    $scope.autoApproveAdvertising(product.id, product);
                }, 1000)
            } else {
                toastr.error('Bật quảng cáo thất bại. ' + response.data.message)
            }
        });
    }
    $scope.onChangeApproveAdvertisingAll = function () {
        let ids = [];
        for (let index = 0; index < $scope.products.length; index++) {
            const element = $scope.products[index];
            if (element.selected) {
                ids.push(element.id);
            }
        }
        $http({
            method: 'POST',
            url: base_api_url + '/product/approve-advertising',
            data: {
                product_id: ids.join(","),
                status: true,
            }
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                toastr.success('Bật quảng cáo thành công');
                setTimeout(function () {
                    $scope.autoApproveAdvertising(ids.join(","), null);
                }, 1000)
            } else {
                toastr.error('Bật quảng cáo thất bại. ' + response.data.message)
            }
        });
    }

    $scope.selectAll = () => {
        $scope.products.forEach((product) => {
            product.selected = $scope.isSelectAll;
        });
        $scope.countSelectedQuantity = $scope.products.filter(item => item.selected).length
    }

    $scope.selectProduct = (product, isSelect) => {
        for (let index = 0; index < $scope.products.length; index++) {
            const element = $scope.products[index];
            if (element.id == product.id) {
                element.selected = isSelect;
            }
        }
        $scope.countSelectedQuantity = $scope.products.filter(item => item.selected).length
    }
    
    $scope.initialize();
}