system.controller("ProductWarningController", ProductWarningController);

function ProductWarningController($scope, $http, $rootScope) {
  
  $scope.perPage = 40;
  $scope.sortDate = ['LAST_7_DAYS'];
  $scope.pagesCount = 0;
  $scope.items = [];
  $scope.isSort = false;
  $scope.indexItem = 0;
  $scope.filters = {
    page_id: 0,
  };
  $scope.crawlStatus = [
    {
      value: 1,
      name: "Đã crawl"
    },
    {
      value: 0,
      name: "Chưa crawl"
    }
  ];
  const stringCrawled = ',product-crawled';



  $scope.initialize = function() {
    $scope.find();
  }

  $scope.find = function (isChangeData, sort = null ) {
    if(sort != null) {
      $scope.filters.sort = sort;
    }

    if(isChangeData){
      $scope.filters.page_id = 0;
    }

    const data = buildFilter();


    $http
      .post("/product-warning/api/get-list-warning", data)
      .then((res) => {
        const response = res.data;
        if(response.status == 'successful') {
            $scope.items = response.result.data.data;
            $scope.indexItem = $scope.perPage * response.result.meta_data.page_id;
            $scope.pagesCount = response.result.meta_data.page_count;
            $scope.filters.page_id = response.result.meta_data.page_id;
        }
      })
      .catch((err) => {
        console.log(err);
      });
  };

  $scope.checkCrawled = (value) => {
    return value.includes(stringCrawled)
  }

  $scope.reset = function(){
    $scope.filters = {
      page_id: 0,
      sort: null
    }

    $scope.find();
  }

  $scope.handleChecked = (item) => {
    const url = '/product-warning/api/update-crawl-status';
    const data = {
      product_id: item.product_id,
      sku: item.sku,
      crawled: stringCrawled
    };
    
    $http.post(url, data)
    .then((res) => {
      if(res.data.status == 'successful') {
          toastr.success("Cập nhật trạng thái thành công.");
      } else {
          toastr.error("Có lỗi xảy ra, xin thử lại");
      }
    })
    .catch((err) => {
      console.log(err);
    });

  }

  function buildFilter() {
    $scope.filters;
    let data = {
      page_id: $scope.filters.page_id,
    }
    if($scope.filters.sort) {
      data.sort = $scope.filters.sort;
    }
    if($scope.filters.start_date) {
      data.start_date = $scope.filters.start_date;
    }
    if($scope.filters.end_date) {
      data.end_date = $scope.filters.end_date;
    }
    if($scope.filters.name) {
      data.name = $scope.filters.name;
    }
    if($scope.filters.sku) {
      data.sku = $scope.filters.sku;
    }
    if($scope.filters.crawlStatus) {
      data.crawl_status = $scope.filters.crawlStatus.value;
    }

    return data;
  }

  $scope.initialize();
}
