system.controller("ReportDeviceController", ReportDeviceController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ReportDeviceController($rootScope, $scope, $http) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;
    $scope.devices = [
        {code: 'mobile', title: 'Mobile'},
        {code: 'desktop', title: 'Desktop'},
        {code: 'tablet', title: 'Tablet'}
    ];

    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = '';
        $scope.filters.sort = null;
        $scope.filters.device = null;
        
        initDatePicker();
        $scope.find();
    }
    

    initDatePicker = function() {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filters.date_from = new Date(oneMonthAgo);
        $scope.filters.date_to = new Date();
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }

    $scope.exportExcel = function() {
        var url = "/device-report/export-excel";
        var filter = buildFilter();
        var params = getParams(filter);
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        url += '&is_export=1';
        window.open(url, '_blank');
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.find = function (isChangePageData, sort = null) {
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            if (sort != null) {
                $scope.filters.sort = sort;
            }
            var filter = buildFilter();
            // $scope.isShowHideLoading(true);
            $scope.ajaxFindRequest = $http.post("device-report/find", filter).then(function (response) {
                $scope.ajaxFindRequest = null;
                if (response.data.status === "successful") {
                    $scope.items = response.data.result;
                    // $scope.isShowHideLoading(false);
                    $scope.pagesCount = response.data.pagesCount;
                }
            });
        }
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword != '') {
            retVal.keyword = $scope.filters.keyword;
        }
        if (typeof $scope.filters.device != 'undefined' && $scope.filters.device != null) {
            retVal.device = $scope.filters.device.code;
        }
        if (typeof $scope.filters.sort != 'undefined' && $scope.filters.sort != null) {
            retVal.sort = $scope.filters.sort;
        }
       
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    this.initialize();
}