system.controller("ProductReportController", ProductReportController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductReportController($rootScope, $scope, $http) {
    
    var self = this;
    $scope.orderDateFrom;
    $scope.orderDateTo;
    $scope.isShowLoading = true;
    $scope.baseUrl = base_url;

    $scope.sorts = [
        { code: "total_product,desc", name: "Số lượng sản phẩm giảm dần" },
        { code: "total_product,asc", name: "Số lượng sản phẩm tăng dần" },
        { code: "total_amount,desc", name: "Tổng tiền giảm dần" },
        { code: "total_amount,asc", name: "Tổng tiền tăng dần" },
    ];

    $scope.tags = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];

    $scope.categories = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];

    $scope.colors = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];
    $scope.styles = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];

    $scope.sizes = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];
    $scope.types = [
        { code: "", name: "No" },
        { code: "1", name: "Yes" },
    ];

    $scope.filter = {
        sort: $scope.sorts[0],
        color: $scope.colors[0],
        style: $scope.styles[0],
        size: $scope.sizes[0],
        type: $scope.types[0],
        tag: $scope.tags[0],
        category: $scope.categories[0],
        orderDateFrom: '',
        orderDateTo: '',
    };
    $scope.items = [];
    this.initialize = function() {
        this.initDatePicker();
        this.initalFilters();
        $scope.find();
    }

    /**
     * find data by filter
     * @returns {undefined}
     */
     $scope.find = function (isChangePageData) {
        $scope.isFinding = true;
        $scope.isShowHideLoading(true);
        if (isChangePageData) {
            $scope.filter.page_id = 0;
        }
        var dataFilter = self.builFilterData();
        $http.get("/report/product-statistic/find", {
            params: dataFilter
        }).then(function (result) {
            var data = result.data;
            $scope.isFinding = false;
            $scope.isShowHideLoading(false);
            $scope.items = [];
            if (data.status == "successful") {
                $scope.items = data.data;
                if (dataFilter.category) {
                    var listCategory = [];
                    for (var i in $scope.items) {
                        $scope.items[i].count_verifier = 0;
                        listCategory.push($scope.items[i].category_name);
                    }
                    $scope.getVerifierCount(listCategory);
                }

            }
        })
        .catch(function () {
            $scope.isShowHideLoading(true);
            alert("Không thể tải danh sách, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật để được hỗ trợ.");
            $scope.isSaving = false;
        });
    };

    $scope.getVerifierCount = function (listCategory) {
        $http.post("https://central.api.printerval.com/central/verifier-config/get-verifier-count-by-category?service_token=megaads@123", {
            categories: listCategory
        }).then(function (result) {
            var data = result.data;
            if (data && data.status && data.status == "successful") {
                var listCount = data.result;
                for (var i in $scope.items) {
                    if (typeof listCount[$scope.items[i].category_name] != 'undefined') {
                        $scope.items[i].count_verifier = listCount[$scope.items[i].category_name];
                    }
                }
            }
        });
    }



    $scope.reset = function () {
        $scope.filter = {
            sort: $scope.sorts[0],
            color: $scope.colors[0],
            style: $scope.styles[0],
            size: $scope.sizes[0],
            type: $scope.types[0],
            tag: $scope.tags[0],
            category: $scope.categories[0],
            orderDateFrom: '',
            orderDateTo: '',
        };
        $(".datepicker").datepicker({
            dateFormat: "dd/mm/yy"
        });
        var today = new Date();
        var oneMonthAgo = new Date();
        oneMonthAgo.setDate(today.getDate() - 30);
        var lastDay = new Date();
        lastDay.setDate(lastDay.getDate() - 1);
        $scope.orderDateFrom = new Date(oneMonthAgo);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);
        $scope.orderDateTo = lastDay;
        $scope.filter.orderDateTo = lastDay;
        $scope.find();
    };

    $scope.getExcel = function () {
        
        const data = $scope.items;
        /* const data = [
            {
              "product_id": 76967662,
              "color_variant_id": 639,
              "size_variant_id": 1,
              "type_variant_id": 109,
              "style_variant_id": 155,
              "category_id": 7,
              "total_amount": 1385200.2699985,
              "total_product": "71091",
              "total_order": 66015,
              "category_name": "T-Shirts"
            }
          ]; */

        const exportParams = {
            /* "headers": [
                "product_id",
                "color_variant_id",
                "size_variant_id",
                "type_variant_id",
                "style_variant_id",
                "total_amount",
                "total_product",
                "total_order",
                "category_name"
            ], */
            "mode": "download",
            "json_data": data
        };

        const url = '/admin/export-service/export';
        const xhr = new XMLHttpRequest();

        xhr.open('POST', url);
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.responseType = 'blob';

        xhr.onload = function(e) {
            if (this.status == 200) {
                let link = document.createElement('a');
                link.href = window.URL.createObjectURL(this.response);
                link.download = "results.xls";
                link.click();
            }
        }

        xhr.send(JSON.stringify(exportParams));

    };

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    $scope.isShow = function(item) {
        return item.code == 1 ? true : false;
    }


    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        } else if (formatString == 'Y-m-d') {
            return date.getFullYear() + "-" + (date.getMonth()+1) + "-" +  date.getDate();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    this.initDatePicker = function() {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filter.orderDateFrom = new Date(oneMonthAgo);

        var lastDay = new Date();
        lastDay.setDate(lastDay.getDate() - 1);
        $scope.filter.orderDateTo = lastDay;
    }

    this.initalFilters = function() {
        $scope.filter.sort = $scope.sorts[0];
    }

    this.builFilterData = function() {
        var retVal = {};
        let keys = [
            'color', 'size',
            'type', 'style', 'tag', 'category'
        ];
        for (let key of keys) {
            retVal[key] = $scope.filter[key] && $scope.filter[key].code == 1 ? 1 : 0;
        }

        if ($scope.filter.orderDateFrom != 'undefined') {
            retVal.orderDateFrom = formatDate($scope.filter.orderDateFrom, 'dd/mm/yyyy');
        }
        if ($scope.filter.orderDateTo != 'undefined') {
            retVal.orderDateTo = formatDate($scope.filter.orderDateTo, 'dd/mm/yyyy');
        }

        if ($scope.filter.sort) {
            retVal.sort = $scope.filter.sort.code;
        }
        return retVal;
    }



    this.initialize();
}