system.controller("SizeColorMappingController", SizeColorMappingController);

system.config(['chosenProvider', function (chosenProvider) {
    chosenProvider.setOption({
        no_results_text: 'Không tìm thấy kết quả!',
        placeholder_text: 'Choose Values  ▾',
        placeholder_text_multiple: 'Choose Values  ▾'
    });
}]);

var baseColors = ['Azure', 'Black', 'Blue', 'Brown', 'Cyan', 'Green', 'Gray', 'Magenta', 'Orange', 'Pink', 'Purple', 'Red', 'Rose', 'White', 'Yellow'];
var baseSizes = ['S', 'M', 'L', 'XL', 'XXL'];

function SizeColorMappingController($scope, $http, $rootScope, $timeout) {

    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope);

    $scope.isTyping = false;
    $scope.timeOut = setTimeout(() => { }, 0);

    if (generalConfig && typeof generalConfig.color_variant_id != 'undefined')
        $scope.colorVariantId = generalConfig.color_variant_id;

    if (generalConfig && typeof generalConfig.size_variant_id != 'undefined')
        $scope.sizeVariantId = generalConfig.size_variant_id;

    $scope.filters = {
        hide_mapped: false,
        search: ''
    }

    $scope.tempData = {};

    $scope.variantColors = [];
    $scope.colorMap = {};
    $scope.colorConfirm = {};

    $scope.variantSizes = [];
    $scope.sizeMap = {};
    $scope.sizeConfirm = {};

    $scope.colorMapPagination = {
        number_page: 1,
        current_page: 1,
        page_size: 100
    };

    $scope.sizeMapPagination = {
        number_page: 1,
        current_page: 1,
        page_size: 100
    };

    $scope.initialize = function () {

        $('[data-toggle="tooltip"]').tooltip();

        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 1000,
            "timeOut": 5000,
            "extendedTimeOut": 1000
        };

        loadConfig();

    };

    $scope.changeColorVariantId = function () {
        $scope.isTyping = true;
        clearTimeout($scope.timeOut);
        $scope.timeOut = setTimeout(() => {
            $scope.isTyping = false;
            loadVariantColors();
        }, 500);
    }

    $scope.changeColorMap = function () {
        // console.log($scope.colorMap);
    }

    $scope.changeColorConfirm = function () {
        // console.log($scope.colorConfirm);
    }

    $scope.paginate = function (array, page_size, page_number) {
        // human-readable page numbers usually start with 1, so we reduce 1 in the first argument
        return array.slice((page_number - 1) * page_size, page_number * page_size);
    }

    $scope.filter = function () {
        // restore data
        restoreData();

        if($scope.filters.hide_mapped)
            hideMappedItems();
            
        searchColor($scope.filters.search); 
        searchSize($scope.filters.search);

        recaculatePagination();

        /* $timeout(function () {
            $scope.$apply(function () {
               
            });
        }); */
    }

    $scope.search = function() {
        $scope.isTyping = true;
        clearTimeout($scope.timeOut);
        $scope.timeOut = setTimeout(() => {
            $scope.isTyping = false;
            $scope.filter();
        }, 500);
    }

    function searchColor(searchString) {
        let filterData = [];
        for (let index = 0; index < $scope.variantColors.length; index++) {
            if (
                $scope.variantColors[index].search(searchString) >= 0
            ) {
                filterData.push($scope.variantColors[index]);
            }
        }
        $scope.variantColors = angular.copy(filterData);
    }

    function searchSize(searchString) {
        let filterData = [];
        for (let index = 0; index < $scope.variantSizes.length; index++) {
            if (
                $scope.variantSizes[index].includes(searchString)
            ) {
                filterData.push($scope.variantSizes[index]);
            }
        }
        $scope.variantSizes = angular.copy(filterData);
    }

    function hideMappedItems() {

        let filterData = [];
        let variantColors = angular.copy($scope.variantColors);

        for (let index = 0; index < variantColors.length; index++) {
            if (
                typeof $scope.colorMap[variantColors[index]] == 'undefined'
                || !$scope.colorMap[variantColors[index]].length
            ) {
                filterData.push(variantColors[index]);
            }
        }

        let filterDataSize = [];
        let variantSizes = angular.copy($scope.variantSizes);
        for (let index = 0; index < variantSizes.length; index++) {
            if (
                typeof $scope.sizeMap[variantSizes[index]] == 'undefined'
                || !$scope.sizeMap[variantSizes[index]].length
            ) {
                filterDataSize.push(variantSizes[index]);
            }
        }

        $scope.variantSizes = angular.copy(filterDataSize);
        $scope.variantColors = angular.copy(filterData);
    }

    function backupTemp() {
        $scope.tempData = {};
        $scope.tempData.variantColors = angular.copy($scope.variantColors);
        $scope.tempData.variantSizes = angular.copy($scope.variantSizes);
    }

    function restoreData() {
        if ($scope.tempData.variantColors && $scope.tempData.variantColors.length)
            $scope.variantColors = angular.copy($scope.tempData.variantColors);

        if ($scope.tempData.variantSizes && $scope.tempData.variantSizes.length)
            $scope.variantSizes = angular.copy($scope.tempData.variantSizes);
    }

    $scope.createColor = function (newColor) {
        $scope.colors.push(newColor);
        if (this.container && this.container.length) {
            let chosenContainer = this.container[0];
            let chosenSelect = chosenContainer.parentElement.getElementsByTagName('select');

            if (typeof chosenSelect != 'undefined' && chosenSelect.length) {
                chosenSelect = chosenSelect[0];
                if (typeof $scope.colorMap[chosenSelect.dataset.color] == 'undefined' || !$scope.colorMap[chosenSelect.dataset.color]) {
                    $scope.colorMap[chosenSelect.dataset.color] = [];
                }
                $scope.colorMap[chosenSelect.dataset.color].push(newColor);
                $scope.changeColorMap();
            }
        }
    }

    function loadConfig() {
        // key: module::ads::size_color_map
        /* defaultConfig 
            {"color_map":{},"color_confirm":{},"size_map":{},"size_confirm":{},"standard_color":[],"standard_size":[]}
        */

        $http({
            method: 'get',
            url: base_api_url + '/option?filters=key=module::ads::size_color_map&metric=first'
        }).then(function success(response) {
            if (response.data.status == 'successful') {

                let configResponse = response.data.result;
                if (configResponse && configResponse.value) {
                    let configs = JSON.parse(configResponse.value);
                    $scope.optionDataId = configResponse.id;

                    $scope.colors = configs.standard_color;
                    $scope.colorMap = configs.color_map;
                    $scope.colorConfirm = configs.color_confirm;

                    $scope.sizes = configs.standard_size;
                    $scope.sizeMap = configs.size_map;
                    $scope.sizeConfirm = configs.size_confirm;


                    if (typeof $scope.colors == 'undefined' || $scope.colors.length == 0)
                        $scope.colors = baseColors;

                    if (typeof $scope.sizes == 'undefined' || $scope.sizes.length == 0)
                        $scope.sizes = baseSizes;

                    if ($scope.colorVariantId) {
                        loadVariantColors();
                    } else {
                        toastr.error('Error load variant colors!');
                    }

                    if ($scope.sizeVariantId) {
                        loadVariantSizes();
                    } else {
                        toastr.error('Error load variant sizes!');
                    }
                }

            } else {
                toastr.error('Error load config!');
            }
        });

    }

    function loadVariantColors() {
        $http({
            method: 'get',
            url: base_api_url + '/product_variant_option?filters=variant_id=' + $scope.colorVariantId +
                '&page_size=-1'
        }).then(function success(response) {
            $('.loader.color').hide();
            if (response.data.status == 'successful') {
                for (let index = 0; index < response.data.result.length; index++) {
                    let color = response.data.result[index];

                    if (color.name)
                        color.name = color.name.toLowerCase();

                    if (!$scope.variantColors.includes(color)) {
                        $scope.variantColors.push(color.name);
                        // autoMap(color.name);
                    }
                }

                let countPage = $scope.variantColors.length / $scope.colorMapPagination.page_size;
                countPage = Math.ceil(countPage);

                $scope.colorMapPagination.number_page = countPage;
                backupTemp();

            } else {
                toastr.error('Error loadVariantColors!');
            }
        });
    }

    function loadVariantSizes() {
        $http({
            method: 'get',
            url: base_api_url + '/product_variant_option?filters=variant_id=' + $scope.sizeVariantId +
                '&page_size=-1'
        }).then(function success(response) {
            $('.loader.size').hide();
            if (response.data.status == 'successful') {
                for (let index = 0; index < response.data.result.length; index++) {
                    let size = response.data.result[index];

                    if (size.name)
                        size.name = size.name.toLowerCase();

                    if (!$scope.variantSizes.includes(size)) {
                        $scope.variantSizes.push(size.name);
                        // autoMap(color.name);
                    }
                }

                let countPage = $scope.variantSizes.length / $scope.sizeMapPagination.page_size;
                countPage = Math.ceil(countPage);

                $scope.sizeMapPagination.number_page = countPage;
                backupTemp();

            } else {
                toastr.error('Error loadVariantSizes!');
            }
        });
    }

    $scope.saveMap = function () {

        $scope.loaddingButton('#btnSaveMap', 'Saving . . .');

        let optionValue = {
            color_map: {},
            color_confirm: {},
            size_map: {},
            size_confirm: {},
            size_confirm: {},
            standard_color: [],
            standard_size: [],
        }

        optionValue.color_map = $scope.colorMap;
        optionValue.color_confirm = $scope.colorConfirm;
        optionValue.standard_color = $scope.colors;

        optionValue.size_map = $scope.sizeMap;
        optionValue.standard_size = $scope.sizes;

        $http({
            method: 'put',
            url: base_api_url + '/option/' + $scope.optionDataId,
            data: {
                value: JSON.stringify(optionValue)
            }
        }).then(function success(response) {
            $scope.stopLoaddingButton('#btnSaveMap');
            if (response.data.status == 'successful') {
                toastr.success('Saved! Everything good');
            } else {
                toastr.error('Error saveMap!');
            }
        });

    }

    $scope.autoMapColors = function () {
        $scope.loaddingButton('#autoMapColor', 'Processing . . .');
        for (let index = 0; index < $scope.variantColors.length; index++) {
            let color = $scope.variantColors[index];
            autoMap(color);
        }

        setTimeout(() => {
            $scope.stopLoaddingButton('#autoMapColor');
        }, 300);

    }

    function autoMap(color) {
        // tìm trong base color
        if (typeof $scope.colorConfirm[color] == 'undefined' || !$scope.colorConfirm[color]) {
            $scope.colorMap[color] = [];
            for (let index = 0; index < baseColors.length; index++) {
                let baseColor = baseColors[index];
                if (color.includes(baseColor.toLowerCase()))
                    $scope.colorMap[color].push(baseColor);
            }
        }
    }

    function recaculatePagination() {
        let countPage = $scope.variantColors.length / $scope.colorMapPagination.page_size;
        countPage = Math.ceil(countPage);

        let countPageSize = $scope.variantSizes.length / $scope.sizeMapPagination.page_size;
        countPageSize = Math.ceil(countPageSize);

        $timeout(function() {
            $scope.$apply(function() {
                $scope.colorMapPagination.number_page = countPage;
                $scope.colorMapPagination.current_page = 1;
        
                $scope.sizeMapPagination.number_page = countPageSize;
                $scope.sizeMapPagination.current_page = 1;
            });
        });
    }

    $scope.range = function (min, max, step) {
        step = step || 1;
        var input = [];
        for (var i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    $scope.initialize();
}