system.controller("ApproveAdvertiseController", ApproveAdvertiseController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };

});
function ApproveAdvertiseController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    this.__proto__ = new PaginationController($scope, $http, $rootScope);
    $scope.controllerName = "ApproveAdvertiseController";

    $scope.locales = [
        { key: "us", value: "United States" },
        { key: "au", value: "Australia" },
        { key: "ca", value: "Canada" },
        { key: "uk", value: "United Kingdom" },
        { key: "fr", value: "France" },
        { key: "de", value: "Germany" },
        { key: "it", value: "Italy" },
        { key: "pt", value: "Portugal" },
        { key: "jp", value: "Japan" },
        { key: "es", value: "Spain" },
    ];
    $scope.products = [];
    $scope.initialize = function () {
        $scope.localeSelected = $scope.locales[0].key;
    }

    $scope.loadFile = async function ($files) {
        if (!$files || !$files.length) {
            return;
        }
        const file = $files[0];
        $scope.products = [];
        const reader = new FileReader();
        $scope.products = await new Promise((resolve, reject) => {
            let fileExt = $scope.getFileExtension(file.name);
            reader.onload = function (e) {
                let content = e.target.result;
                let products = $scope.processData(content, fileExt);
                resolve(products);
            };
            if (fileExt == 'csv') {
                reader.readAsText(file);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                reader.readAsBinaryString(file);
            }
        });
        safeApply();
    }

    $scope.getFileExtension = (filename) => {
        const ext = /^.+\.([^.]+)$/.exec(filename);
        return ext == null ? "" : ext[1];
    }

    $scope.processData = (content, fileExt) => {
        let objects = [];
        try {
            if (fileExt == 'csv') {
                // Parse the CSV content into rows
                let rows = content.split('\n');
                rows.forEach((row, index) => {
                    if (index > 0 && row.trim()) {  // Skip header row and empty lines
                        let columns = row.split(',');
                        let productID = columns[0];
                        objects.push({ productId: productID });
                    }
                });
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                let workbook = XLSX.read(content, { type: 'binary' });
                workbook.SheetNames.forEach(sheet => {
                    let arrayObject = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheet]);
                    objects = objects.concat(arrayObject.map(item => {
                        return { productId: item['Product ID'] };  // Assuming 'Product ID' is the header name for product IDs in Excel
                    }));
                });
            }
        } catch (ex) {
            console.log(ex);
            $scope.showErrorModal('Không thể đọc được file.');
        }

        return objects;
    }

    $scope.applyData = function () {
        const url = '/' + $scope.localeSelected + '/service/ads/approve-printerest?ignore_localization=1';
        const data = { ids: $scope.products.map(product => product.productId) };
        $http.post(url, data).then(response => {
            $scope.showSuccessModal('Dữ liệu đã được cập nhật thành công.');
        })
    }

    $scope.initialize();

    function safeApply() {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }
}