document.addEventListener("DOMContentLoaded", function () {
    var today = new Date();
    var sevenDaysAgo = new Date();
    sevenDaysAgo.setDate(today.getDate() - 7);

    var todayString = today.toISOString().split('T')[0];
    var sevenDaysAgoString = sevenDaysAgo.toISOString().split('T')[0];

    document.getElementById('startDate').value = sevenDaysAgoString;
    document.getElementById('endDate').value = todayString;
});

function loadChartData(event, url) {
    event.preventDefault();

    var startDate = document.getElementById('startDate').value;
    var endDate = document.getElementById('endDate').value;
    $.ajax({
        url: `${url}?start_date=${startDate}&end_date=${endDate}`,
        type: 'GET',
        success: function (data) {
            var categories = data.result.categories;
            var series = data.result.series.map(function (dataset) {
                return {
                    name: dataset.name,
                    data: dataset.data,
                };
            });
            var notPushedSeries = data.result.not_pushed_series.map(function (dataset) {
                return {
                    name: dataset.name,
                    data: dataset.data,
                };
            });

            //vẽ chart sản phẩm theo ngày
            var summaryProduct = data.summaryProduct;
            renderChartSummaryProduct(summaryProduct);

            Highcharts.chart('container', {
                chart: {
                    type: 'line'
                },
                title: {
                    text: 'Products meta'
                },
                xAxis: {
                    categories: categories
                },
                yAxis: {
                    type: 'logarithmic',
                    title: {
                        text: 'Quantity'
                    }
                },
                series: series
            });

            Highcharts.chart('second-container', {
                chart: {
                    type: 'column'
                },
                title: {
                    text: 'Products not pushed in 90 days'
                },
                xAxis: {
                    categories: ['Products']
                },
                yAxis: {
                    min: 0,
                    title: {
                        text: 'Quantity'
                    },
                    stackLabels: {
                        enabled: true
                    }
                },
                tooltip: {
                    headerFormat: '<b>{point.x}</b><br/>',
                    pointFormat: '{series.name}: {point.y}<br/>Total: {point.stackTotal}'
                },
                plotOptions: {
                    column: {
                        stacking: 'normal',
                        dataLabels: {
                            enabled: true
                        }
                    },
                    series: {
                        pointWidth: 40
                    }
                },
                series: notPushedSeries
            });
        }
    });
}

function renderChartSummaryProduct(summaryData) {
    const date = summaryData.map(item => item.date);

    const sellerData = summaryData.map(item => Number(item.total_seller));
    const nonSellerData = summaryData.map(item => Number(item.total_non_seller));

    Highcharts.chart('three-container', {
        chart: {
            type: 'column',
            style: {
                fontFamily: 'Arial', // Đặt font chữ rõ nét hơn
                fontSize: '16px'     // Tăng kích thước chung cho biểu đồ
            }
        },
        title: {
            text: 'Tổng sản phẩm theo ngày',
            style: {
                fontSize: '18px',    // Tăng kích thước chữ tiêu đề
                fontWeight: 'bold'
            }
        },
        xAxis: {
            categories: date,
            title: {
                text: 'Ngày',
                style: {
                    fontSize: '14px', // Tăng kích thước chữ của trục x
                }
            },
            labels: {
                style: {
                    fontSize: '12px' // Tăng kích thước chữ nhãn trục x
                }
            }
        },
        yAxis: {
            min: 0,
            title: {
                text: 'Tổng số sản phẩm',
                style: {
                    fontSize: '14px'  // Tăng kích thước chữ của trục y
                }
            },
            labels: {
                style: {
                    fontSize: '12px'  // Tăng kích thước chữ nhãn trục y
                }
            },
            stackLabels: {
                enabled: true,        // Bật hiển thị tổng số
                style: {
                    fontSize: '12px',  // Kích thước chữ cho tổng số
                    color: 'black'
                },
                formatter: function () {
                    return this.total;
                }
            }
        },
        tooltip: {
            style: {
                fontSize: '14px'  // Tăng kích thước chữ trong tooltip
            }
        },
        legend: {
            itemStyle: {
                fontSize: '13px',  // Tăng kích thước chữ trong chú thích
            }
        },
        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: true,
                    style: {
                        fontSize: '12px'  // Tăng kích thước chữ trên cột
                    }
                }
            },
            series: {
                pointWidth: 40
            }
        },
        series: [
            {
                name: 'Sản phẩm của Seller',
                data: sellerData,
                color: '#7cb5ec'
            },
            {
                name: 'Sản phẩm của Content',
                data: nonSellerData,
                color: '#90ed7d'
            },
        ]
    });
}

// Initial render
$(document).ready(function () {
    $('button[onclick*="loadChartData"]').trigger('click');
});