system.controller("AdvertisingController", AdvertisingController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };

});
function AdvertisingController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    this.__proto__ = new PaginationController($scope, $http, $rootScope);
    $scope.controllerName = "AdvertisingController";
    $scope.items = [];
    $scope.filter = {};
    $scope.saving = false;
    $scope.mode = "create";
    $scope.advertising = {};
    $scope.selectedAdvertising = [];
    $scope.logs = [];
    $scope.logsProduct = [];
    this.initialize = function () {
        $scope.meta = {
            page_id: 0,
            page_size: 100,
        };
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.type = $scope.typesClick[0];
        $scope.filter.order = $scope.orders[0];
        initDatePicker();
        var filter = $scope.getCacheFilter('product_advertiser_filter');
        if (filter) {
            try {
                $scope.filter = JSON.parse(filter);
            } catch (error) {
                console.error(error);
            }
        }
        $scope.find();
    };

    $scope.customPageSize = "100";

    $scope.advertisingStatuses = [
        {
            key: "1",
            value: "Đang bật",
        },
        {
            key: "0",
            value: "Đang tắt",
        },
    ];
    $scope.typesClick = [
        {
            key: "all",
            value: "-- Tất cả --",
        },
        {
            key: "no_click",
            value: "Sản phẩm không có click",
        },
        {
            key: "has_click",
            value: "Sản phẩm có click",
        },
    ];
    $scope.reset = function () {
        $scope.filter = {};
        $scope.filter.sort = $scope.sorts[0];
        $scope.filter.type = $scope.typesClick[0];
        initDatePicker();
        $scope.find();
    };
    $scope.sorts = [
        { code: "-1", name: "Sắp xếp" },
        { code: "adwords_down", name: "Click adwords giảm" },
        { code: "adwords_up", name: "Click adwords tăng" },
        { code: "google_down", name: "Click organic giảm" },
        { code: "google_up", name: "Click organic tăng" },
        { code: "bing_down", name: "Click bing giảm" },
        { code: "bing_up", name: "Click bing tăng" },
    ];
    $scope.orders = [
        { code: "id_desc", name: "Từ mới đến cũ" },
        { code: "id_asc", name: "Từ cũ đến mới" },
        { code: "ctr_desc", name: "Ctr giảm dần" },
        { code: "ctr_asc", name: "Ctr tăng dần" },
    ];

    $scope.find = function () {
        var url = $scope.buildAdvertisingUrl("/module/approved-vertising/find");
        $scope.cacheFilter('product_advertiser_filter', JSON.stringify($scope.filter));
        let filter = $scope.buildFilter();
        var params = getParams(filter);
        if (params.length > 0) {
            url += "&" + params.join("&");
        }
        $http.get(url).then(
            function successCallback(response) {
                if (response.data.status == "successful") {
                    var result = response.data.result;
                    $scope.meta = response.data.meta;
                    $scope.items = result;
                    $scope.items.forEach((element) => {
                        element.selected = false;
                    });
                }
            },
            function error() {
                toastr.error("Bạn không có quyền sử dụng dịch vụ!");
            }
        );
    };

    $scope.buildAdvertisingUrl = (url) => {
        url = $scope.buildFilterUrl(url);
        url = $scope.buildPaginationUrl(url, $scope.customPageSize);
        return url;
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.keypressFilter = function (event) {
        if (event.keyCode == 13) {
            $scope.filter.pageId = 0;
            $scope.find();
        }
    };

    $scope.openModal = (advertising) => {
        $scope.advertising = angular.copy(advertising);
        $("#approveAdvertising").modal();
    };

    $scope.closeModal = () => {
        $("#approveAdvertising").modal("hide");
        $scope.advertising = angular.copy($scope.advertising);
    };
    $scope.openModalLog = (advertising) => {
        $scope.logs = [];
        $scope.advertising = angular.copy(advertising);
        $http
            .get(base_api_url + "/log?sorts=-created_at&filters=target_type=ADVERTISING,target_id=" + advertising.id)
            .then((response) => {
                    if (response.data.status == "successful") {
                        $scope.logs = response.data.result;
                        $scope.logs.forEach(element => {
                            element.data = JSON.parse(element.data)
                        });
                    }
                },
            );
        $("#logAdvertising").modal();
    };

    $scope.closeModalLog = () => {
        $("#logAdvertising").modal("hide");
        $scope.advertising = angular.copy($scope.advertising);
    };
    $scope.openModalLogProduct = (advertising) => {
        $scope.logsProduct = [];
        $scope.advertising = angular.copy(advertising);
        $http
            .get(base_api_url + "/log?sorts=-created_at&filters=target_type=PRODUCT,target_id=" + advertising.product_id)
            .then((response) => {
                    if (response.data.status == "successful") {
                        $scope.logsProduct = response.data.result;
                        $scope.logsProduct.forEach(element => {
                            element.data = JSON.parse(element.data)
                        });
                    }
                },
            );
        $("#logProductAdvertising").modal();
    };

    $scope.closeModalLog = () => {
        $("#logProductAdvertising").modal("hide");
        $scope.advertising = angular.copy($scope.advertising);
    };

    $scope.save = () => {
        if (typeof $scope.advertising.title == "undefined" || $scope.advertising.title == "") {
            toastr.error("Vui lòng điền tên");
            return;
        }
        if (typeof $scope.advertising.description == "undefined" || $scope.advertising.description == "") {
            toastr.error("Vui lòng điền mô tả");
            return;
        }
        let data = {
            title: $scope.advertising.title,
            description: $scope.advertising.description,
        };
        $http.put(base_api_url + "/approveAdvertising/" + $scope.advertising.id, data).then(
            (response) => {
                if (response.data.status == "successful") {
                    toastr.success("Cập nhật thành công.");
                } else {
                    toastr.error("Có lỗi! Vui lòng thử lại");
                }
                $("#approveAdvertising").modal("hide");
                $scope.find();
            },
            function error() {
                toastr.error("Bạn không có quyền sử dụng dịch vụ!");
            }
        );
    };

    $scope.onChangeApproveAdvertising = (advertising) => {
        let status = advertising.advertising_status == 1 ? 0 : 1;
        $http
            .patch(base_api_url + "/approveAdvertising/" + advertising.id, {
                advertising_status: status,
            })
            .then(
                (response) => {
                    if (response.data.status == "successful") {
                        toastr.success("Cập nhật thành công.");
                        $scope.items.forEach(element => {
                            if (element.id == advertising.id) {
                                element.advertising_status = status;
                            }
                        });
                    } else {
                        toastr.error("Có lỗi! Vui lòng thử lại");
                    }
                    $scope.find();
                },
                function error() {
                    toastr.error("Bạn không có quyền sử dụng dịch vụ!");
                }
            );
    };
    $scope.onChangeApproveAdvertising = (advertising) => {
        let status = advertising.advertising_status == 1 ? 0 : 1;
        $http
            .patch(base_api_url + "/approveAdvertising/" + advertising.id, {
                advertising_status: status,
            })
            .then(
                (response) => {
                    if (response.data.status == "successful") {
                        toastr.success("Cập nhật thành công.");
                        $scope.items.forEach(element => {
                            if (element.id == advertising.id) {
                                element.advertising_status = status;
                            }
                        });
                    } else {
                        toastr.error("Có lỗi! Vui lòng thử lại");
                    }
                    $scope.find();
                },
                function error() {
                    toastr.error("Bạn không có quyền sử dụng dịch vụ!");
                }
            );
    };

    $scope.selectAllAdvertising = () => {
        if ($scope.selectedAdvertising.length > 0) {
            if ($scope.selectedAdvertising.length == 20) {
                $scope.selectedAdvertising = [];
                $scope.items.forEach((element) => {
                    element.selected = false;
                });
            } else {
                $scope.items.forEach((element) => {
                    if (!$scope.selectedAdvertising.includes(element.id)) {
                        $scope.selectedAdvertising.push(element.id);
                    }
                    element.selected = true;
                });
            }
        } else {
            $scope.items.forEach((element) => {
                $scope.selectedAdvertising.push(element.id);
                element.selected = true;
            });
        }
    };

    $scope.addSelectedAdvertising = (item) => {
        $scope.items.forEach((element) => {
            if (element.id == item.id) {
                if (!item.selected) {
                    $scope.selectedAdvertising.push(element.id);
                } else {
                    $scope.selectedAdvertising = $scope.selectedAdvertising.filter((i) => i != element.id);
                }
            }
        });
    };

    $scope.changeBulkStatusAdvertising = (type) => {
        let status = true;
        if (type == "Inactive") {
            status = false;
        }
        if ($scope.selectedAdvertising.length > 0) {
            var url = $scope.buildUrl("/advertising/approve");
            var text = "Tắt " + $scope.selectedAdvertising.length + " sản phẩm";
            var title = "Bật";
            if (type == "Active") {
                text = "Bật " + $scope.selectedAdvertising.length + " sản phẩm";
                title = "Bật";
            }
            let data = $scope.selectedAdvertising.join(",");
            $scope.callConfirmModal(
                {
                    title: title,
                    text: text,
                },
                function () {
                    $http
                        .post(url, {
                            ids: data,
                            status: status,
                        })
                        .then(
                            function success(response) {
                                if (response.data.status == "successful") {
                                    toastr.success(title + " quảng cáo thành công");
                                } else {
                                    toastr.error(title + " quảng cáo thất bại. " + response.data.message);
                                }
                                $scope.selectedAdvertising = [];
                                $("#js-product-checkall")[0].checked = false;
                                $scope.find();
                            },
                            function error() {
                                toastr.error("Bạn không có quyền sử dụng dịch vụ!");
                            }
                        );
                }
            );
        }
    };

    $scope.buildFilter = () => {
        let retVal = {};
        if ($scope.filter.searchName && $scope.filter.searchName != "") {
            retVal.search = $scope.filter.searchName;
        }
        if (
            typeof $scope.filter.advertising_status !== "undefined" &&
            $scope.filter.advertising_status != null &&
            typeof $scope.filter.advertising_status.key !== "undefined" &&
            $scope.filter.advertising_status.key != ""
        ) {
            retVal.advertising_status = $scope.filter.advertising_status.key;
        }
        if (typeof $scope.filter.type !== "undefined" && $scope.filter.type != null && typeof $scope.filter.type.key !== "undefined" && $scope.filter.type.key != "") {
            retVal.zero_click = $scope.filter.type.key;
        }
        if (typeof $scope.filter.sort != "undefined" && $scope.filter.sort != null && $scope.filter.sort.code != "undefined" && $scope.filter.sort.code != "" && $scope.filter.sort.code != "-1") {
            retVal.sort = $scope.filter.sort.code;
        }
        if ($scope.filter.order) {
            retVal.order = $scope.filter.order.code;
        }
        retVal.dateFrom = formatDate($scope.filter.dateFrom, "dd/mm/yyyy");
        retVal.dateTo = formatDate($scope.filter.dateTo, "dd/mm/yyyy");
        return retVal;
    };

    getParams = function (filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = "";
            if (typeof filterValue == "object" || typeof filterValue == "array") {
                if (filterValue.length > 0) {
                    param = key + "=" + filterValue.join(",");
                }
            } else {
                param = key + "=" + filterValue;
            }
            if (param != "") {
                params.push(param);
            }
        }
        return params;
    };

    formatDate = function (date, formatString) {
        if (typeof date == "string") {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, "$2/$1/$3");
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? "pm" : "am";
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? "0" + minutes : minutes;
        var strTime = hours + ":" + minutes + " " + ampm;
        if (formatString == "dd/mm/yyyy") {
            return date.getDate() + "/" + (date.getMonth() + 1) + "/" + date.getFullYear();
        }
        return date.getMonth() + 1 + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    };
    initDatePicker = function () {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filter.dateFrom = new Date(oneMonthAgo);
        $scope.filter.dateTo = new Date();
    };

    $scope.changeTypeClick = () => {
        $scope.filter.sort = $scope.sorts[0];
        $scope.find();
    }
    this.initialize();
}
