system.controller("ProductToAdvertiseController", ProductToAdvertiseController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };

});

function ProductToAdvertiseController($rootScope, $scope, $http) {
    
    $scope.isChangeData = false;
    $scope.products = [];
    $scope.isShowProducts = false;
    $scope.productCursorPosition = 0;
    $scope.searchProduct = "";
    $scope.isChangeData = false;
    $scope.ajaxFindRequest = null;
    $scope.adwordsItem = [];
    $scope.pagesCount = 0;
    $scope.beforeAdwords = {};
    $scope.reportDateTo;
    $scope.reportDateFrom; 
    $scope.accounts = accounts;
    $scope.isShowLoading = false;
    $scope.product = {
        item: {}
    };

    $scope.adTypes = [
        {code: 'dsa', title: 'DSA'},
        {code: 'text_ad', title: 'TEXT_AD'}
    ];
    $scope.campaignTypes = [
        {code: 'SEARCH', title: 'SEARCH'}, 
        {code: 'SHOPPING', title: 'SHOPPING'},
        {code: 'DISPLAY', title: 'DISPLAY'}
    ];
    $scope.sorts = [
        {code: 'click_asc', name: 'Click tăng'},
        {code: 'click_desc', name: 'Click giảm'},
        {code: 'inventory_asc', name: 'Tồn kho tăng'},
        {code: 'inventory_desc', name: 'Tồn kho giảm'},
    ];
    $scope.inventories = [
        {code: 'in_stock', title: 'Còn hàng'},
        {code: 'out_of_stock', title: 'Hết hàng'}
    ];

    $scope.filters = {};
    // Set adgroup status by statues
    $scope.statuses = [
        {code: "", name: "Chưa xác định"},
        {code: "pending", name: "Đang chờ"},
        {code: "running", name: "Đang chạy"}
    ];

    $scope.feedStatuses = [
        {code: "", name: "Chưa xác định"},
        {code: "feed_up", name: "Đã lên feed"},
        {code: "feed_down", name: "Chưa lên feed"}
    ];
    $scope.categories = categories;
    $scope.campaigns = [];
    $scope.campaignByIds = {};
    $scope.activeTab = 'base';
    $scope.items = [];

    this.initialize = function() {
        initDatePicker();
        initalFilters();
        resetFilter();
    }


    $scope.changeSort = function () {
        if (($scope.filters.sort != 'undefined'
            && $scope.filters.sort != null
            && $scope.filters.sort.code == 'click_asc') 
            || ($scope.filters.sort != 'undefined'
            && $scope.filters.sort != null
            && $scope.filters.sort.code == 'click_desc')) {
                $scope.filters.not_click = 1;
            }
    }

    $scope.reset = function () {
        $scope.isSaving = false;
        $scope.isFinding = false;
        resetFilter();
        $('.errorMessage').empty();
    };

    $scope.keypressFilter = function (event) {
        if (event.keyCode === 13) {
            $scope.find(true);
        }
    };
    $scope.getByCode = function (list, code) {
        var retVal = null;
        list.forEach(function (item) {
            if (item.code == code) {
                retVal = item;
            }
        });
        //return
        return retVal;
    };

    $scope.changeCampaignType = function() {
        if ($scope.filters.campaign_type != 'undefined' 
            && $scope.filters.campaign_type.code != 'undefined' 
            && $scope.filters.campaign_type.code != 'SEARCH'
            ) {
                $scope.filters.ad_type = null;
            }
    }

    $scope.changeChecked = function() {
        if ($scope.filters.not_advertising || $scope.filters.not_click) {
            $scope.filters.status = {code: "", name: "Chưa xác định"};
        }
        if ($scope.filters.not_click) {
            $scope.filters.sort = null;
        }
    }

    $scope.changeSelected = function() {
        if ($scope.filters.status.code != '') {
            $scope.filters.not_advertising = 0;
        }
    }
    

    $scope.find = function (isChangePageData) {
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            $scope.isShowHideLoading(true);
            $scope.ajaxFindRequest = $http.post("/product-advertise/find", buildFilter()).then(function (response) {
                $scope.ajaxFindRequest = null;
                $scope.isSaving = false;
                
                if (response.data.status === "success") {
                    $scope.products = response.data.products;
                    var productCodes = [];
                    $scope.products.forEach(function(product){
                        productCodes.push(product.sku);
                        product.is_push_merchant_feed = parseInt(product.is_push_merchant_feed);
                        product.data = product.ads;
                    });
                    if (productCodes.length > 0) {
                        buildDetailClick(productCodes);
                    } else {
                        $scope.items = [];
                    }
                    $scope.isShowHideLoading(false);
                    $scope.pagesCount = response.data.pagesCount;
                }
            });
        }
    };

    function buildDetailClick(productCodes) {
        var filter = buildFilter();
        filter.codes = productCodes;
        $http.post(`/product-advertise/build-campaign-click`, filter).then(function (response) {
            if (response.data.status == 'successful') {
                var mapByCodeAndAdType = {};
                response.data.result.forEach(function(item){
                    if (typeof mapByCodeAndAdType[item.product_code + '-' + item.campaign_type] == 'undefined') {
                        mapByCodeAndAdType[item.product_code + '-' + item.campaign_type] = [];
                    }
                    mapByCodeAndAdType[item.product_code + '-' + item.campaign_type].push(item);
                });
                var products = [];
                $scope.products.forEach(function(item) {
                    if (typeof item.click_campaign_types != 'undefined') {
                        item.click_campaign_types.forEach(function(it){
                            var key = it.product_code + '-' + it.campaign_type;
                            if (typeof mapByCodeAndAdType[key] != 'undefined') {
                                var detail = '';
                                for(var i = 0; i < mapByCodeAndAdType[key].length; i++) {
                                    if (typeof mapByCodeAndAdType[key][i].campaign != 'undefined') {
                                        detail += 'Tài khoản: ' + mapByCodeAndAdType[key][i].campaign.account + '<br>'
                                                + 'Chiến dịch: ' + mapByCodeAndAdType[key][i].campaign.campaign_name + ' (' + mapByCodeAndAdType[key][i].campaign.status + ')<br>'
                                                + 'Click: ' + mapByCodeAndAdType[key][i].click + '<br>'
                                                + '-----------------------------------------<br>';
                                    }
                                }
                                if (detail == '') {
                                    detail = 'Không xác định';
                                }
                                it.detail = detail;
                            }
                        });
                    }
                    products.push(item);
                });
                $scope.items = products;
            }
        });
    }

    $scope.exportExcel = function() {
        var url = "/product-advertise/export-excel";
        var filter = buildFilter();
        var params = getParams(filter);
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        url += '&is_export=1';
        window.open(url, '_blank');
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    buildFilter = function() {
        var retVal = {};
        if ($scope.filters.keyword != '') {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.campaign_id != '') {
            retVal.campaign_id = $scope.filters.campaign_id;
        }
        if (typeof $scope.filters.not_advertising != 'undefined') {
            retVal.not_advertising = $scope.filters.not_advertising;
        }
        if (typeof $scope.filters.not_click != 'undefined') {
            retVal.not_click = $scope.filters.not_click;
        }
        if (typeof $scope.filters.status != 'undefined'
            && typeof $scope.filters.status.code != 'undefined'
            && $scope.filters.status.code != ''
        ) {
            retVal.status = $scope.filters.status.code;
        }
        if (typeof $scope.filters.feedStatus != 'undefined'
                && typeof $scope.filters.feedStatus.code != 'undefined'
                && $scope.filters.feedStatus.code != ''
        ) {
            retVal.feed_status = $scope.filters.feedStatus.code;
        }
        if (typeof $scope.filters.account != 'undefined'
                && $scope.filters.account != null
                && typeof $scope.filters.account.code != 'undefined'
                && $scope.filters.account.code != ''
        ) {
            retVal.account_key = $scope.filters.account.code;
        }
        if (typeof $scope.filters.campaign_type != 'undefined'
                && $scope.filters.campaign_type != null
                && typeof $scope.filters.campaign_type.code != 'undefined'
                && $scope.filters.campaign_type.code != ''
        ) {
            retVal.campaign_type = $scope.filters.campaign_type.code;
        }
        if (retVal.campaign_type == 'SEARCH' && typeof $scope.filters.ad_type != 'undefined'
                && $scope.filters.ad_type != null
                && typeof $scope.filters.ad_type.code != 'undefined'
                && $scope.filters.ad_type.code != ''
        ) {
            retVal.ad_type = $scope.filters.ad_type.code;
        }
        if (typeof $scope.filters.sort != 'undefined'
                && $scope.filters.sort != null
                && $scope.filters.sort.code != 'undefined'
                && $scope.filters.sort.code != ''
        ) {
            retVal.sort = $scope.filters.sort.code;
        }
        if (typeof $scope.filters.category != 'undefined' && $scope.filters.category != null) {
            retVal.category_id = $scope.filters.category.id;
        }
        if (typeof $scope.filters.stock != 'undefined' && $scope.filters.stock != null) {
            retVal.stock = $scope.filters.stock.code;
        }
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = '';
        $scope.filters.campaign_id = '';
        $scope.filters.status = {code: "", name: "Chưa xác định"};
        $scope.filters.page_id = 0;
        $scope.filters.not_click = 0;
        $scope.filters.not_advertising = 0;
        $scope.filters.feedStatus = {code: "", name: "Chưa xác định"};
        $scope.filters.sort = $scope.sorts[0];
        $scope.filters.campaign_type = null;
        $scope.filters.ad_type = null;
        $scope.filters.account = null;
        
        initDatePicker();
        $scope.find();
    }
    

    initDatePicker = function() {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 30);
        $scope.filters.date_from = new Date(oneMonthAgo);
        $scope.filters.date_to = new Date();
    }

    initalFilters = function() {
        $scope.filters.status = $scope.statuses[0];
        $scope.filters.feedStatus = $scope.feedStatuses[0];
        $scope.filters.stock = $scope.inventories[0];
        $scope.filters.sort = $scope.sorts[0];
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
      }

    this.initialize();
}