@extends('system.layout.main', [])
@section('title')
    <title>Đẩy quảng cáo số lượng lớn</title>
@endsection
@section('content')

<link rel="stylesheet" href="@asset('ads/css/bulk-approve-product.css')?v=<?= Config::get("sa.version") ?>">

<div class="content" ng-controller="BulkApproveProductController">

    <div class="action-header" style="margin-bottom: 20px; margin-top: 35px">
        <h4>Đẩy QC số lượng lớn</h4>
    </div>
   
    <div class="panel panel-default">

        <div class="push-waiting" ng-if="states.isPushing">
            <span>
                <div class="loader">
                    <div class="inner one"></div>
                    <div class="inner two"></div>
                    <div class="inner three"></div>
                </div>
                <p style="margin-top: 8px">
                    Đang đẩy @{{ states.pushCount }}/@{{ states.lengthProductPushing }} sản phẩm...
                </p>
            </span>
        </div>

        <div class="panel-heading" style="display: flex">
            <div style="padding: 5px 8px">Bộ lọc sản phẩm</div>
            <button style="margin-left: auto" class="btn-push" ng-show="states.checkCount" ng-click="pushProducts()">
                <strong>Đẩy @{{ states.checkCount }} sản phẩm</strong>
            </button>
        </div>

        <table class="table">

            <tr>
                <th colspan="3" class="filter-from">
                    <select chosen ng-model="filters.staff" class="chosen-actor" ng-options="staff.id as staff.name for staff in staffs">
                        <option value="">-- Chọn người tạo --</option>
                    </select>

                    {{-- <input ng-model="filters.from" 
                        ng-keyup="$event.keyCode == 13 && getProducts()"
                        style="margin-left: 5px" type="text" my-date-picker placeholder="--Ngày tạo từ--">
                    → --}}

                    <input ng-model="filters.from" 
                        ng-keyup="$event.keyCode == 13 && getProducts()"
                        type="text" my-date-picker placeholder="--Ngày tạo--">

                    <button ng-click="getProducts()" style="line-height: 22px; margin-left: 5px">Tìm kiếm</button>
                </th>
            </tr>

            <tr ng-show="states.isLoading">
                <td colspan="3" style="padding: 50px; height: 180px">
                    <div class="loader">
                        <div class="inner one"></div>
                        <div class="inner two"></div>
                        <div class="inner three"></div>
                    </div>
                </td>
            </tr>

            <tr ng-show="!states.isLoading && !products.length">
                <td colspan="3" style="padding: 60px; text-align: center; height: 180px">
                    <p>Không tìm được sản phẩm thỏa mãn</p>
                </td>
            </tr>

            <tr ng-show="products.length">
                <th style="vertical-align: middle">
                    <input type="checkbox" id="selectAllProduct" ng-disabled="!products.length">
                </th>
                <th>
                    Danh mục
                </th>
                <th>
                    Số lượng sản phẩm
                </th>
            </tr>

            <tr class="product-item" ng-repeat="(id, reportCategory) in categoryReport track by $index" ng-click="checkProduct(reportCategory, id)">
                <td style="vertical-align: middle">
                    <input type="checkbox" ng-model="checkboxCategory[id]" ng-change="checkIsChanged()">
                </td>
                <td>
                    @{{ reportCategory.name }}
                </td>
                <td>
                    <strong>@{{ reportCategory.count }}</strong>
                </td>
            </tr>
            
        </table>
    </div>

</div>

@endsection


@section('script')

    <script>
        window.staffs = {!! json_encode($staffs) !!};
        window.userId = {!! auth()->user()->id !!};
    </script>

    <script src="@asset('ads/js/moment.min.js')"></script>
    <script src="@asset('ads/controllers/bulk-approve-product-controller.js')?v=<?= Config::get("sa.version") ?>"></script>
@endsection