@extends('system.layout.main', [
    'ngController' => 'ApproveByLinkController'
])

@section('title')
    <title>Duyệt/Tắt quảng cáo sản phẩm</title>
@endsection


@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();

        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/modules/ads/controllers/approve-by-link-controller.js?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Duyệt/Tắt sản quảng cáo phẩm bằng link
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="form-group">
                            <span class="text-danger" style="margin-bottom: 10px;">(*) Mỗi link một dòng</span>
                            <textarea class="form-control" placeholder="Danh sách links"
                                      rows="10"
                                      ng-model="productLinks" style="resize: vertical"
                                      on-change="inputOnChange()"
                            ></textarea>
                        </div>
                        <div style="margin: 10px 0px;">
                            <span class="text-danger">Danh sách ID:</span>
                            <span>
                                @{{ productIds  }}
                            </span>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <select class="form-control" ng-model="type" ng-options="item.key as item.value for item in types">
                                    <option value="">Chọn hành động</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-success" ng-disabled="loading || !type" ng-click="save()">
                                    <span ng-if="!loading">Lưu</span>
                                    <i class="fa fa-spinter fa-spin" ng-if="loading"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection